/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.explain.FieldSelection;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.explain.MemoryEstimation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class ExplainDataFrameAnalyticsResponse
implements ToXContentObject {
    public static final ParseField TYPE = new ParseField("explain_data_frame_analytics_response", new String[0]);
    public static final ParseField FIELD_SELECTION = new ParseField("field_selection", new String[0]);
    public static final ParseField MEMORY_ESTIMATION = new ParseField("memory_estimation", new String[0]);
    static final ConstructingObjectParser<ExplainDataFrameAnalyticsResponse, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), true, args -> new ExplainDataFrameAnalyticsResponse((List)args[0], (MemoryEstimation)args[1]));
    private final List<FieldSelection> fieldSelection;
    private final MemoryEstimation memoryEstimation;

    public static ExplainDataFrameAnalyticsResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public ExplainDataFrameAnalyticsResponse(List<FieldSelection> fieldSelection, MemoryEstimation memoryEstimation) {
        this.fieldSelection = Objects.requireNonNull(fieldSelection);
        this.memoryEstimation = Objects.requireNonNull(memoryEstimation);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_SELECTION.getPreferredName(), this.fieldSelection);
        builder.field(MEMORY_ESTIMATION.getPreferredName(), this.memoryEstimation);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ExplainDataFrameAnalyticsResponse that = (ExplainDataFrameAnalyticsResponse)other;
        return Objects.equals(this.fieldSelection, that.fieldSelection) && Objects.equals(this.memoryEstimation, that.memoryEstimation);
    }

    public int hashCode() {
        return Objects.hash(this.fieldSelection, this.memoryEstimation);
    }

    public MemoryEstimation getMemoryEstimation() {
        return this.memoryEstimation;
    }

    public List<FieldSelection> getFieldSelection() {
        return this.fieldSelection;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), FieldSelection.PARSER, FIELD_SELECTION);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), MemoryEstimation.PARSER, MEMORY_ESTIMATION);
    }
}

