/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;

public class DeleteTrainedModelRequest
implements Validatable {
    private final String id;

    public DeleteTrainedModelRequest(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.id == null) {
            return Optional.of(ValidationException.withError("trained model id must not be null"));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteTrainedModelRequest other = (DeleteTrainedModelRequest)o;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

