/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.Template;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class SimulateIndexTemplateResponse {
    private static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    private static final ParseField OVERLAPPING = new ParseField("overlapping", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField INDEX_PATTERNS = new ParseField("index_patterns", new String[0]);
    private static final ConstructingObjectParser<SimulateIndexTemplateResponse, Void> PARSER = new ConstructingObjectParser("simulate_index_templates_response", false, a -> new SimulateIndexTemplateResponse(a[0] != null ? (Template)a[0] : null, a[1] != null ? ((List)a[1]).stream().collect(Collectors.toMap(IndexTemplateAndPatterns::name, IndexTemplateAndPatterns::indexPatterns)) : null));
    private static final ConstructingObjectParser<IndexTemplateAndPatterns, Void> INNER_PARSER = new ConstructingObjectParser("index_template_and_patterns", false, a -> new IndexTemplateAndPatterns((String)a[0], (List)a[1]));
    @Nullable
    private Template resolvedTemplate;
    @Nullable
    private Map<String, List<String>> overlappingTemplates;

    SimulateIndexTemplateResponse(@Nullable Template resolvedTemplate, @Nullable Map<String, List<String>> overlappingTemplates) {
        this.resolvedTemplate = resolvedTemplate;
        this.overlappingTemplates = overlappingTemplates;
    }

    public static SimulateIndexTemplateResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public Template resolvedTemplate() {
        return this.resolvedTemplate;
    }

    public Map<String, List<String>> overlappingTemplates() {
        return this.overlappingTemplates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulateIndexTemplateResponse that = (SimulateIndexTemplateResponse)o;
        return Objects.equals(this.resolvedTemplate, that.resolvedTemplate) && Objects.deepEquals(this.overlappingTemplates, that.overlappingTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.resolvedTemplate, this.overlappingTemplates);
    }

    public String toString() {
        return "SimulateIndexTemplateResponse{resolved template=" + this.resolvedTemplate + ", overlapping templates=" + String.join((CharSequence)"|", this.overlappingTemplates.keySet()) + "}";
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), Template.PARSER, TEMPLATE);
        INNER_PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        INNER_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX_PATTERNS);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), INNER_PARSER, OVERLAPPING);
    }

    private static class IndexTemplateAndPatterns {
        String name;
        List<String> indexPatterns;

        IndexTemplateAndPatterns(String name, List<String> indexPatterns) {
            this.name = name;
            this.indexPatterns = indexPatterns;
        }

        public String name() {
            return this.name;
        }

        public List<String> indexPatterns() {
            return this.indexPatterns;
        }
    }
}

