/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.snapshots.clone;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.IndicesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ValidateActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.MasterNodeRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class CloneSnapshotRequest
extends MasterNodeRequest<CloneSnapshotRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    private final String repository;
    private final String source;
    private final String target;
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandHidden();

    public CloneSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readString();
        this.source = in.readString();
        this.target = in.readString();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    public CloneSnapshotRequest(String repository, String source, String target, String[] indices) {
        this.repository = repository;
        this.source = source;
        this.target = target;
        this.indices = indices;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.repository);
        out.writeString(this.source);
        out.writeString(this.target);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source snapshot name is missing", null);
        }
        if (this.target == null) {
            validationException = ValidateActions.addValidationError("target snapshot name is missing", null);
        }
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("indices is null", validationException);
        } else if (this.indices.length == 0) {
            validationException = ValidateActions.addValidationError("indices patterns are empty", validationException);
        } else {
            for (String index : this.indices) {
                if (index != null) continue;
                validationException = ValidateActions.addValidationError("index is null", validationException);
                break;
            }
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public CloneSnapshotRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public CloneSnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public String target() {
        return this.target;
    }

    public String source() {
        return this.source;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("repository", this.repository);
        builder.field("source", this.source);
        builder.field("target", this.target);
        if (this.indices != null) {
            builder.startArray("indices");
            for (String index : this.indices) {
                builder.value(index);
            }
            builder.endArray();
        }
        if (this.indicesOptions != null) {
            this.indicesOptions.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }
}

