/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.usage;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;

public class NodesUsageRequest
extends BaseNodesRequest<NodesUsageRequest> {
    private boolean restActions;
    private boolean aggregations;

    public NodesUsageRequest(StreamInput in) throws IOException {
        super(in);
        this.restActions = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
            this.aggregations = in.readBoolean();
        }
    }

    public NodesUsageRequest(String ... nodesIds) {
        super(nodesIds);
    }

    public NodesUsageRequest all() {
        this.restActions = true;
        this.aggregations = true;
        return this;
    }

    public NodesUsageRequest clear() {
        this.restActions = false;
        return this;
    }

    public boolean restActions() {
        return this.restActions;
    }

    public NodesUsageRequest restActions(boolean restActions) {
        this.restActions = restActions;
        return this;
    }

    public boolean aggregations() {
        return this.aggregations;
    }

    public NodesUsageRequest aggregations(boolean aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.restActions);
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeBoolean(this.aggregations);
        }
    }
}

