/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.configuration;

import java.io.IOException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchTimeoutException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.configuration.AddVotingConfigExclusionsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterStateObserver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.Metadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Priority;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportAddVotingConfigExclusionsAction
extends TransportMasterNodeAction<AddVotingConfigExclusionsRequest, AddVotingConfigExclusionsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportAddVotingConfigExclusionsAction.class);
    public static final Setting<Integer> MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING = Setting.intSetting("cluster.max_voting_config_exclusions", 10, 1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile int maxVotingConfigExclusions;

    @Inject
    public TransportAddVotingConfigExclusionsAction(Settings settings, ClusterSettings clusterSettings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/voting_config/add_exclusions", transportService, clusterService, threadPool, actionFilters, AddVotingConfigExclusionsRequest::new, indexNameExpressionResolver);
        this.maxVotingConfigExclusions = MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING, this::setMaxVotingConfigExclusions);
    }

    private void setMaxVotingConfigExclusions(int maxVotingConfigExclusions) {
        this.maxVotingConfigExclusions = maxVotingConfigExclusions;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AddVotingConfigExclusionsResponse read(StreamInput in) throws IOException {
        return new AddVotingConfigExclusionsResponse(in);
    }

    @Override
    protected void masterOperation(final AddVotingConfigExclusionsRequest request, ClusterState state, final ActionListener<AddVotingConfigExclusionsResponse> listener) throws Exception {
        TransportAddVotingConfigExclusionsAction.resolveVotingConfigExclusionsAndCheckMaximum(request, state, this.maxVotingConfigExclusions);
        this.clusterService.submitStateUpdateTask("add-voting-config-exclusions", new ClusterStateUpdateTask(Priority.URGENT){
            private Set<CoordinationMetadata.VotingConfigExclusion> resolvedExclusions;

            @Override
            public ClusterState execute(ClusterState currentState) {
                assert (this.resolvedExclusions == null) : this.resolvedExclusions;
                int finalMaxVotingConfigExclusions = TransportAddVotingConfigExclusionsAction.this.maxVotingConfigExclusions;
                this.resolvedExclusions = TransportAddVotingConfigExclusionsAction.resolveVotingConfigExclusionsAndCheckMaximum(request, currentState, finalMaxVotingConfigExclusions);
                CoordinationMetadata.Builder builder = CoordinationMetadata.builder(currentState.coordinationMetadata());
                this.resolvedExclusions.forEach(builder::addVotingConfigExclusion);
                Metadata newMetadata = Metadata.builder(currentState.metadata()).coordinationMetadata(builder.build()).build();
                ClusterState newState = ClusterState.builder(currentState).metadata(newMetadata).build();
                assert (newState.getVotingConfigExclusions().size() <= finalMaxVotingConfigExclusions);
                return newState;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                ClusterStateObserver observer = new ClusterStateObserver(TransportAddVotingConfigExclusionsAction.this.clusterService, request.getTimeout(), logger, TransportAddVotingConfigExclusionsAction.this.threadPool.getThreadContext());
                Set excludedNodeIds = this.resolvedExclusions.stream().map(CoordinationMetadata.VotingConfigExclusion::getNodeId).collect(Collectors.toSet());
                Predicate<ClusterState> allNodesRemoved = clusterState -> {
                    Set<String> votingConfigNodeIds = clusterState.getLastCommittedConfiguration().getNodeIds();
                    return excludedNodeIds.stream().noneMatch(votingConfigNodeIds::contains);
                };
                ClusterStateObserver.Listener clusterStateListener = new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        listener.onResponse(new AddVotingConfigExclusionsResponse());
                    }

                    @Override
                    public void onClusterServiceClose() {
                        listener.onFailure(new ElasticsearchException("cluster service closed while waiting for voting config exclusions " + resolvedExclusions + " to take effect", new Object[0]));
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        listener.onFailure(new ElasticsearchTimeoutException("timed out waiting for voting config exclusions " + resolvedExclusions + " to take effect", new Object[0]));
                    }
                };
                if (allNodesRemoved.test(newState)) {
                    clusterStateListener.onNewClusterState(newState);
                } else {
                    observer.waitForNextChange(clusterStateListener, allNodesRemoved);
                }
            }
        });
    }

    private static Set<CoordinationMetadata.VotingConfigExclusion> resolveVotingConfigExclusionsAndCheckMaximum(AddVotingConfigExclusionsRequest request, ClusterState state, int maxVotingConfigExclusions) {
        return request.resolveVotingConfigExclusionsAndCheckMaximum(state, maxVotingConfigExclusions, MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING.getKey());
    }

    @Override
    protected ClusterBlockException checkBlock(AddVotingConfigExclusionsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

