/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.DeltaPackedLongValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.PackedInts;

class MonotonicLongValues
extends DeltaPackedLongValues {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MonotonicLongValues.class);
    final float[] averages;

    MonotonicLongValues(int pageShift, int pageMask, PackedInts.Reader[] values, long[] mins, float[] averages, long size, long ramBytesUsed) {
        super(pageShift, pageMask, values, mins, size, ramBytesUsed);
        assert (values.length == averages.length);
        this.averages = averages;
    }

    @Override
    long get(int block, int element) {
        return MonotonicBlockPackedReader.expected(this.mins[block], this.averages[block], element) + this.values[block].get(element);
    }

    @Override
    int decodeBlock(int block, long[] dest) {
        int count = super.decodeBlock(block, dest);
        float average = this.averages[block];
        for (int i = 0; i < count; ++i) {
            int n = i;
            dest[n] = dest[n] + MonotonicBlockPackedReader.expected(0L, average, i);
        }
        return count;
    }

    static class Builder
    extends DeltaPackedLongValues.Builder {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Builder.class);
        float[] averages;

        Builder(int pageSize, float acceptableOverheadRatio) {
            super(pageSize, acceptableOverheadRatio);
            this.averages = new float[this.values.length];
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.averages);
        }

        @Override
        long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public MonotonicLongValues build() {
            this.finish();
            this.pending = null;
            Accountable[] values = ArrayUtil.copyOfSubArray(this.values, 0, this.valuesOff);
            long[] mins = ArrayUtil.copyOfSubArray(this.mins, 0, this.valuesOff);
            float[] averages = ArrayUtil.copyOfSubArray(this.averages, 0, this.valuesOff);
            long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(values) + RamUsageEstimator.sizeOf(mins) + RamUsageEstimator.sizeOf(averages);
            return new MonotonicLongValues(this.pageShift, this.pageMask, (PackedInts.Reader[])values, mins, averages, this.size, ramBytesUsed);
        }

        @Override
        void pack(long[] values, int numValues, int block, float acceptableOverheadRatio) {
            float average = numValues == 1 ? 0.0f : (float)(values[numValues - 1] - values[0]) / (float)(numValues - 1);
            for (int i = 0; i < numValues; ++i) {
                int n = i;
                values[n] = values[n] - MonotonicBlockPackedReader.expected(0L, average, i);
            }
            super.pack(values, numValues, block, acceptableOverheadRatio);
            this.averages[block] = average;
        }

        @Override
        void grow(int newBlockCount) {
            super.grow(newBlockCount);
            this.ramBytesUsed -= RamUsageEstimator.sizeOf(this.averages);
            this.averages = ArrayUtil.growExact(this.averages, newBlockCount);
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.averages);
        }
    }
}

