/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRefArray;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRefIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.FixedLengthBytesRefArray;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.PriorityQueue;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.SameThreadExecutorService;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.SortableBytesRefArray;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ThreadInterruptedException;

public class OfflineSorter {
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long MIN_BUFFER_SIZE_MB = 32L;
    public static final long ABSOLUTE_MIN_SORT_BUFFER_SIZE = 524288L;
    private static final String MIN_BUFFER_SIZE_MSG = "At least 0.5MB RAM buffer is needed";
    public static final int MAX_TEMPFILES = 10;
    private final Directory dir;
    private final int valueLength;
    private final String tempFileNamePrefix;
    private final ExecutorService exec;
    private final Semaphore partitionsInRAM;
    private final BufferSize ramBufferSize;
    SortInfo sortInfo;
    private int maxTempFiles;
    private final Comparator<BytesRef> comparator;
    public static final Comparator<BytesRef> DEFAULT_COMPARATOR = Comparator.naturalOrder();

    public OfflineSorter(Directory dir, String tempFileNamePrefix) throws IOException {
        this(dir, tempFileNamePrefix, DEFAULT_COMPARATOR, BufferSize.automatic(), 10, -1, null, 0);
    }

    public OfflineSorter(Directory dir, String tempFileNamePrefix, Comparator<BytesRef> comparator) throws IOException {
        this(dir, tempFileNamePrefix, comparator, BufferSize.automatic(), 10, -1, null, 0);
    }

    public OfflineSorter(Directory dir, String tempFileNamePrefix, Comparator<BytesRef> comparator, BufferSize ramBufferSize, int maxTempfiles, int valueLength, ExecutorService exec, int maxPartitionsInRAM) {
        if (exec != null) {
            this.exec = exec;
            if (maxPartitionsInRAM <= 0) {
                throw new IllegalArgumentException("maxPartitionsInRAM must be > 0; got " + maxPartitionsInRAM);
            }
        } else {
            this.exec = new SameThreadExecutorService();
            maxPartitionsInRAM = 1;
        }
        this.partitionsInRAM = new Semaphore(maxPartitionsInRAM);
        if ((long)ramBufferSize.bytes < 524288L) {
            throw new IllegalArgumentException("At least 0.5MB RAM buffer is needed: " + ramBufferSize.bytes);
        }
        if (maxTempfiles < 2) {
            throw new IllegalArgumentException("maxTempFiles must be >= 2");
        }
        if (valueLength != -1 && (valueLength == 0 || valueLength > Short.MAX_VALUE)) {
            throw new IllegalArgumentException("valueLength must be 1 .. 32767; got: " + valueLength);
        }
        this.valueLength = valueLength;
        this.ramBufferSize = ramBufferSize;
        this.maxTempFiles = maxTempfiles;
        this.comparator = comparator;
        this.dir = dir;
        this.tempFileNamePrefix = tempFileNamePrefix;
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public String getTempFileNamePrefix() {
        return this.tempFileNamePrefix;
    }

    /*
     * Exception decompiling
     */
    public String sort(String inputFileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void verifyChecksum(Throwable priorException, ByteSequencesReader reader) throws IOException {
        try (ChecksumIndexInput in = this.dir.openChecksumInput(reader.name, IOContext.READONCE);){
            CodecUtil.checkFooter(in, priorException);
        }
    }

    void mergePartitions(Directory trackingDir, List<Future<Partition>> segments) throws IOException {
        long start = System.currentTimeMillis();
        List<Future<Partition>> segmentsToMerge = segments.size() > this.maxTempFiles ? segments.subList(segments.size() - this.maxTempFiles, segments.size()) : segments;
        ++this.sortInfo.mergeRounds;
        MergePartitionsTask task = new MergePartitionsTask(trackingDir, new ArrayList<Future<Partition>>(segmentsToMerge));
        segmentsToMerge.clear();
        segments.add(this.exec.submit(task));
        ++this.sortInfo.tempMergeFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Partition readPartition(ByteSequencesReader reader) throws IOException, InterruptedException {
        if (this.partitionsInRAM != null) {
            this.partitionsInRAM.acquire();
        }
        boolean success = false;
        try {
            SortableBytesRefArray buffer;
            long start = System.currentTimeMillis();
            boolean exhausted = false;
            if (this.valueLength != -1) {
                buffer = new FixedLengthBytesRefArray(this.valueLength);
                int limit = this.ramBufferSize.bytes / this.valueLength;
                for (int i = 0; i < limit; ++i) {
                    BytesRef item = null;
                    try {
                        item = reader.next();
                    }
                    catch (Throwable t) {
                        this.verifyChecksum(t, reader);
                    }
                    if (item == null) {
                        exhausted = true;
                        break;
                    }
                    buffer.append(item);
                }
            } else {
                Counter bufferBytesUsed = Counter.newCounter();
                buffer = new BytesRefArray(bufferBytesUsed);
                do {
                    BytesRef item = null;
                    try {
                        item = reader.next();
                    }
                    catch (Throwable t) {
                        this.verifyChecksum(t, reader);
                    }
                    if (item == null) {
                        exhausted = true;
                        break;
                    }
                    buffer.append(item);
                } while (bufferBytesUsed.get() <= (long)this.ramBufferSize.bytes);
            }
            this.sortInfo.readTimeMS += System.currentTimeMillis() - start;
            success = true;
            Partition partition = new Partition(buffer, exhausted);
            return partition;
        }
        finally {
            if (!success && this.partitionsInRAM != null) {
                this.partitionsInRAM.release();
            }
        }
    }

    protected ByteSequencesWriter getWriter(IndexOutput out, long itemCount) throws IOException {
        return new ByteSequencesWriter(out);
    }

    protected ByteSequencesReader getReader(ChecksumIndexInput in, String name) throws IOException {
        return new ByteSequencesReader(in, name);
    }

    public Comparator<BytesRef> getComparator() {
        return this.comparator;
    }

    private Partition getPartition(Future<Partition> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            throw IOUtils.rethrowAlways(cause != null ? cause : ee);
        }
    }

    static /* synthetic */ Semaphore access$300(OfflineSorter x0) {
        return x0.partitionsInRAM;
    }

    private class MergePartitionsTask
    implements Callable<Partition> {
        private final Directory dir;
        private final List<Future<Partition>> segmentsToMerge;

        public MergePartitionsTask(Directory dir, List<Future<Partition>> segmentsToMerge) {
            this.dir = dir;
            this.segmentsToMerge = segmentsToMerge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public Partition call() throws IOException {
            long totalCount = 0L;
            for (Future<Partition> segment : this.segmentsToMerge) {
                totalCount += ((OfflineSorter)OfflineSorter.this).getPartition(segment).count;
            }
            PriorityQueue<FileAndTop> queue = new PriorityQueue<FileAndTop>(this.segmentsToMerge.size()){

                @Override
                protected boolean lessThan(FileAndTop a, FileAndTop b) {
                    return OfflineSorter.this.comparator.compare(a.current, b.current) < 0;
                }
            };
            Closeable[] streams = new ByteSequencesReader[this.segmentsToMerge.size()];
            String newSegmentName = null;
            long startMS = System.currentTimeMillis();
            try {
                ByteSequencesWriter writer = OfflineSorter.this.getWriter(this.dir.createTempOutput(OfflineSorter.this.tempFileNamePrefix, "sort", IOContext.DEFAULT), totalCount);
                Object object = null;
                try {
                    FileAndTop fileAndTop;
                    void var10_9;
                    newSegmentName = writer.out.getName();
                    boolean bl = false;
                    while (var10_9 < this.segmentsToMerge.size()) {
                        Partition segment = OfflineSorter.this.getPartition(this.segmentsToMerge.get((int)var10_9));
                        streams[var10_9] = OfflineSorter.this.getReader(this.dir.openChecksumInput(segment.fileName, IOContext.READONCE), segment.fileName);
                        BytesRef item = null;
                        try {
                            item = ((ByteSequencesReader)streams[var10_9]).next();
                        }
                        catch (Throwable t) {
                            OfflineSorter.this.verifyChecksum(t, (ByteSequencesReader)streams[var10_9]);
                        }
                        assert (item != null);
                        queue.insertWithOverflow(new FileAndTop((int)var10_9, item));
                        ++var10_9;
                    }
                    while ((fileAndTop = (FileAndTop)queue.top()) != null) {
                        writer.write(fileAndTop.current);
                        try {
                            fileAndTop.current = ((ByteSequencesReader)streams[fileAndTop.fd]).next();
                        }
                        catch (Throwable t) {
                            OfflineSorter.this.verifyChecksum(t, (ByteSequencesReader)streams[fileAndTop.fd]);
                        }
                        if (fileAndTop.current != null) {
                            queue.updateTop();
                            continue;
                        }
                        queue.pop();
                    }
                    CodecUtil.writeFooter(writer.out);
                    for (Closeable reader : streams) {
                        CodecUtil.checkFooter(((ByteSequencesReader)reader).in);
                    }
                    OfflineSorter.this.sortInfo.mergeTimeMS.addAndGet(System.currentTimeMillis() - startMS);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            finally {
                IOUtils.close(streams);
            }
            ArrayList<String> toDelete = new ArrayList<String>();
            for (Future future : this.segmentsToMerge) {
                toDelete.add(((OfflineSorter)OfflineSorter.this).getPartition((Future)future).fileName);
            }
            IOUtils.deleteFiles(this.dir, toDelete);
            return new Partition(newSegmentName, totalCount);
        }
    }

    private class SortPartitionTask
    implements Callable<Partition> {
        private final Directory dir;
        private final Partition part;

        public SortPartitionTask(Directory dir, Partition part) {
            this.dir = dir;
            this.part = part;
        }

        /*
         * Exception decompiling
         */
        @Override
        public Partition call() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class ByteSequencesReader
    implements BytesRefIterator,
    Closeable {
        protected final String name;
        protected final ChecksumIndexInput in;
        protected final long end;
        private final BytesRefBuilder ref = new BytesRefBuilder();

        public ByteSequencesReader(ChecksumIndexInput in, String name) {
            this.in = in;
            this.name = name;
            this.end = in.length() - (long)CodecUtil.footerLength();
        }

        @Override
        public BytesRef next() throws IOException {
            if (this.in.getFilePointer() >= this.end) {
                return null;
            }
            short length = this.in.readShort();
            this.ref.grow(length);
            this.ref.setLength(length);
            this.in.readBytes(this.ref.bytes(), 0, length);
            return this.ref.get();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    public static class ByteSequencesWriter
    implements Closeable {
        protected final IndexOutput out;

        public ByteSequencesWriter(IndexOutput out) {
            this.out = out;
        }

        public final void write(BytesRef ref) throws IOException {
            assert (ref != null);
            this.write(ref.bytes, ref.offset, ref.length);
        }

        public final void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            assert (bytes != null);
            assert (off >= 0 && off + len <= bytes.length);
            assert (len >= 0);
            if (len > Short.MAX_VALUE) {
                throw new IllegalArgumentException("len must be <= 32767; got " + len);
            }
            this.out.writeShort((short)len);
            this.out.writeBytes(bytes, off, len);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    static class FileAndTop {
        final int fd;
        BytesRef current;

        FileAndTop(int fd, BytesRef firstLine) {
            this.fd = fd;
            this.current = firstLine;
        }
    }

    private static class Partition {
        public final SortableBytesRefArray buffer;
        public final boolean exhausted;
        public final long count;
        public final String fileName;

        public Partition(SortableBytesRefArray buffer, boolean exhausted) {
            this.buffer = buffer;
            this.fileName = null;
            this.count = buffer.size();
            this.exhausted = exhausted;
        }

        public Partition(String fileName, long count) {
            this.buffer = null;
            this.fileName = fileName;
            this.count = count;
            this.exhausted = true;
        }
    }

    public class SortInfo {
        public int tempMergeFiles;
        public int mergeRounds;
        public int lineCount;
        public final AtomicLong mergeTimeMS = new AtomicLong();
        public final AtomicLong sortTimeMS = new AtomicLong();
        public long totalTimeMS;
        public long readTimeMS;
        public final long bufferSize;

        public SortInfo() {
            this.bufferSize = ((OfflineSorter)OfflineSorter.this).ramBufferSize.bytes;
        }

        public String toString() {
            return String.format(Locale.ROOT, "time=%.2f sec. total (%.2f reading, %.2f sorting, %.2f merging), lines=%d, temp files=%d, merges=%d, soft ram limit=%.2f MB", (double)this.totalTimeMS / 1000.0, (double)this.readTimeMS / 1000.0, (double)this.sortTimeMS.get() / 1000.0, (double)this.mergeTimeMS.get() / 1000.0, this.lineCount, this.tempMergeFiles, this.mergeRounds, (double)this.bufferSize / 1048576.0);
        }
    }

    public static final class BufferSize {
        final int bytes;

        private BufferSize(long bytes) {
            if (bytes > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Buffer too large for Java (2047mb max): " + bytes);
            }
            if (bytes < 524288L) {
                throw new IllegalArgumentException("At least 0.5MB RAM buffer is needed: " + bytes);
            }
            this.bytes = (int)bytes;
        }

        public static BufferSize megabytes(long mb) {
            return new BufferSize(mb * 0x100000L);
        }

        public static BufferSize automatic() {
            Runtime rt = Runtime.getRuntime();
            long max = rt.maxMemory();
            long total = rt.totalMemory();
            long free = rt.freeMemory();
            long totalAvailableBytes = max - total + free;
            long sortBufferByteSize = free / 2L;
            long minBufferSizeBytes = 0x2000000L;
            if (sortBufferByteSize < 0x2000000L || totalAvailableBytes > 0x14000000L) {
                sortBufferByteSize = totalAvailableBytes / 2L > 0x2000000L ? totalAvailableBytes / 2L : Math.max(524288L, sortBufferByteSize);
            }
            return new BufferSize(Math.min(Integer.MAX_VALUE, sortBufferByteSize));
        }
    }
}

