/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RamUsageEstimator;

public class Accountables {
    private Accountables() {
    }

    public static String toString(Accountable a) {
        StringBuilder sb = new StringBuilder();
        Accountables.toString(sb, a, 0);
        return sb.toString();
    }

    private static StringBuilder toString(StringBuilder dest, Accountable a, int depth) {
        for (int i = 1; i < depth; ++i) {
            dest.append("    ");
        }
        if (depth > 0) {
            dest.append("|-- ");
        }
        dest.append(a.toString());
        dest.append(": ");
        dest.append(RamUsageEstimator.humanReadableUnits(a.ramBytesUsed()));
        dest.append(System.lineSeparator());
        for (Accountable child : a.getChildResources()) {
            Accountables.toString(dest, child, depth + 1);
        }
        return dest;
    }

    public static Accountable namedAccountable(String description, Accountable in) {
        return Accountables.namedAccountable(description + " [" + in + "]", in.getChildResources(), in.ramBytesUsed());
    }

    public static Accountable namedAccountable(String description, long bytes) {
        return Accountables.namedAccountable(description, Collections.emptyList(), bytes);
    }

    public static Collection<Accountable> namedAccountables(String prefix, Map<?, ? extends Accountable> in) {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        for (Map.Entry<?, Accountable> kv : in.entrySet()) {
            resources.add(Accountables.namedAccountable(prefix + " '" + kv.getKey() + "'", kv.getValue()));
        }
        Collections.sort(resources, new Comparator<Accountable>(){

            @Override
            public int compare(Accountable o1, Accountable o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return Collections.unmodifiableList(resources);
    }

    public static Accountable namedAccountable(final String description, final Collection<Accountable> children, final long bytes) {
        return new Accountable(){

            @Override
            public long ramBytesUsed() {
                return bytes;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return children;
            }

            public String toString() {
                return description;
            }
        };
    }
}

