/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.FSDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.FSLockFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Lock;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.LockObtainFailedException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;

public final class NativeFSLockFactory
extends FSLockFactory {
    public static final NativeFSLockFactory INSTANCE = new NativeFSLockFactory();
    private static final Set<String> LOCK_HELD = Collections.synchronizedSet(new HashSet());

    private NativeFSLockFactory() {
    }

    @Override
    protected Lock obtainFSLock(FSDirectory dir, String lockName) throws IOException {
        Path realPath;
        Path lockDir = dir.getDirectory();
        Files.createDirectories(lockDir, new FileAttribute[0]);
        Path lockFile = lockDir.resolve(lockName);
        IOException creationException = null;
        try {
            Files.createFile(lockFile, new FileAttribute[0]);
        }
        catch (IOException ignore) {
            creationException = ignore;
        }
        try {
            realPath = lockFile.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            if (creationException != null) {
                e.addSuppressed(creationException);
            }
            throw e;
        }
        FileTime creationTime = Files.readAttributes(realPath, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        if (LOCK_HELD.add(realPath.toString())) {
            block10: {
                NativeFSLock nativeFSLock;
                block11: {
                    FileChannel channel = null;
                    FileLock lock = null;
                    try {
                        channel = FileChannel.open(realPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                        lock = channel.tryLock();
                        if (lock == null) break block10;
                        nativeFSLock = new NativeFSLock(lock, channel, realPath, creationTime);
                        if (lock != null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (lock == null) {
                            IOUtils.closeWhileHandlingException(channel);
                            NativeFSLockFactory.clearLockHeld(realPath);
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(channel);
                    NativeFSLockFactory.clearLockHeld(realPath);
                }
                return nativeFSLock;
            }
            throw new LockObtainFailedException("Lock held by another program: " + realPath);
        }
        throw new LockObtainFailedException("Lock held by this virtual machine: " + realPath);
    }

    private static final void clearLockHeld(Path path) throws IOException {
        boolean remove = LOCK_HELD.remove(path.toString());
        if (!remove) {
            throw new AlreadyClosedException("Lock path was cleared but never marked as held: " + path);
        }
    }

    static final class NativeFSLock
    extends Lock {
        final FileLock lock;
        final FileChannel channel;
        final Path path;
        final FileTime creationTime;
        volatile boolean closed;

        NativeFSLock(FileLock lock, FileChannel channel, Path path, FileTime creationTime) {
            this.lock = lock;
            this.channel = channel;
            this.path = path;
            this.creationTime = creationTime;
        }

        @Override
        public void ensureValid() throws IOException {
            if (this.closed) {
                throw new AlreadyClosedException("Lock instance already released: " + this);
            }
            if (!LOCK_HELD.contains(this.path.toString())) {
                throw new AlreadyClosedException("Lock path unexpectedly cleared from map: " + this);
            }
            if (!this.lock.isValid()) {
                throw new AlreadyClosedException("FileLock invalidated by an external force: " + this);
            }
            long size = this.channel.size();
            if (size != 0L) {
                throw new AlreadyClosedException("Unexpected lock file size: " + size + ", (lock=" + this + ")");
            }
            FileTime ctime = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]).creationTime();
            if (!this.creationTime.equals(ctime)) {
                throw new AlreadyClosedException("Underlying file changed by an external force at " + ctime + ", (lock=" + this + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try (FileChannel channel = this.channel;
                 FileLock lock = this.lock;){
                assert (lock != null);
                assert (channel != null);
            }
            finally {
                this.closed = true;
                NativeFSLockFactory.clearLockHeld(this.path);
            }
        }

        public String toString() {
            return "NativeFSLock(path=" + this.path + ",impl=" + this.lock + ",creationTime=" + this.creationTime + ")";
        }
    }
}

