/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store;

import java.io.EOFException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.DataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.RandomAccessInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RamUsageEstimator;

public final class ByteBuffersDataInput
extends DataInput
implements Accountable,
RandomAccessInput {
    private final ByteBuffer[] blocks;
    private final int blockBits;
    private final int blockMask;
    private final long size;
    private final long offset;
    private long pos;

    public ByteBuffersDataInput(List<ByteBuffer> buffers) {
        ByteBuffersDataInput.ensureAssumptions(buffers);
        this.blocks = (ByteBuffer[])buffers.stream().map(buf -> buf.asReadOnlyBuffer()).toArray(ByteBuffer[]::new);
        if (this.blocks.length == 1) {
            this.blockBits = 32;
            this.blockMask = -1;
        } else {
            int blockBytes = ByteBuffersDataInput.determineBlockPage(buffers);
            this.blockBits = Integer.numberOfTrailingZeros(blockBytes);
            this.blockMask = (1 << this.blockBits) - 1;
        }
        this.size = Arrays.stream(this.blocks).mapToLong(block -> block.remaining()).sum();
        this.pos = this.offset = (long)this.blocks[0].position();
    }

    public long size() {
        return this.size;
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF * this.blocks.length) + Arrays.stream(this.blocks).mapToLong(buf -> buf.capacity()).sum();
    }

    @Override
    public byte readByte() throws EOFException {
        try {
            ByteBuffer block = this.blocks[this.blockIndex(this.pos)];
            byte v = block.get(this.blockOffset(this.pos));
            ++this.pos;
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            if (this.pos >= this.size()) {
                throw new EOFException();
            }
            throw e;
        }
    }

    public void readBytes(ByteBuffer buffer, int len) throws EOFException {
        try {
            while (len > 0) {
                ByteBuffer block = this.blocks[this.blockIndex(this.pos)].duplicate();
                int blockOffset = this.blockOffset(this.pos);
                block.position(blockOffset);
                int chunk = Math.min(len, block.remaining());
                if (chunk == 0) {
                    throw new EOFException();
                }
                this.pos += (long)chunk;
                block.limit(blockOffset + chunk);
                buffer.put(block);
                len -= chunk;
            }
        }
        catch (ArrayIndexOutOfBoundsException | BufferUnderflowException e) {
            if (this.pos >= this.size()) {
                throw new EOFException();
            }
            throw e;
        }
    }

    @Override
    public void readBytes(byte[] arr, int off, int len) throws EOFException {
        try {
            while (len > 0) {
                ByteBuffer block = this.blocks[this.blockIndex(this.pos)].duplicate();
                block.position(this.blockOffset(this.pos));
                int chunk = Math.min(len, block.remaining());
                if (chunk == 0) {
                    throw new EOFException();
                }
                this.pos += (long)chunk;
                block.get(arr, off, chunk);
                len -= chunk;
                off += chunk;
            }
        }
        catch (ArrayIndexOutOfBoundsException | BufferUnderflowException e) {
            if (this.pos >= this.size()) {
                throw new EOFException();
            }
            throw e;
        }
    }

    @Override
    public byte readByte(long pos) {
        return this.blocks[this.blockIndex(pos += this.offset)].get(this.blockOffset(pos));
    }

    @Override
    public short readShort(long pos) {
        long absPos = this.offset + pos;
        int blockOffset = this.blockOffset(absPos);
        if (blockOffset + 2 <= this.blockMask) {
            return this.blocks[this.blockIndex(absPos)].getShort(blockOffset);
        }
        return (short)((this.readByte(pos) & 0xFF) << 8 | this.readByte(pos + 1L) & 0xFF);
    }

    @Override
    public int readInt(long pos) {
        long absPos = this.offset + pos;
        int blockOffset = this.blockOffset(absPos);
        if (blockOffset + 4 <= this.blockMask) {
            return this.blocks[this.blockIndex(absPos)].getInt(blockOffset);
        }
        return this.readByte(pos) << 24 | (this.readByte(pos + 1L) & 0xFF) << 16 | (this.readByte(pos + 2L) & 0xFF) << 8 | this.readByte(pos + 3L) & 0xFF;
    }

    @Override
    public long readLong(long pos) {
        long absPos = this.offset + pos;
        int blockOffset = this.blockOffset(absPos);
        if (blockOffset + 8 <= this.blockMask) {
            return this.blocks[this.blockIndex(absPos)].getLong(blockOffset);
        }
        return (long)this.readInt(pos) << 32 | (long)this.readInt(pos + 4L) & 0xFFFFFFFFL;
    }

    public long position() {
        return this.pos - this.offset;
    }

    public void seek(long position) throws EOFException {
        this.pos = position + this.offset;
        if (position > this.size()) {
            this.pos = this.size();
            throw new EOFException();
        }
    }

    public ByteBuffersDataInput slice(long offset, long length) {
        if (offset < 0L || length < 0L || offset + length > this.size) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "slice(offset=%s, length=%s) is out of bounds: %s", offset, length, this));
        }
        return new ByteBuffersDataInput(ByteBuffersDataInput.sliceBufferList(Arrays.asList(this.blocks), offset, length));
    }

    public String toString() {
        return String.format(Locale.ROOT, "%,d bytes, block size: %,d, blocks: %,d, position: %,d%s", this.size(), this.blockSize(), this.blocks.length, this.position(), this.offset == 0L ? "" : String.format(Locale.ROOT, " [offset: %,d]", this.offset));
    }

    private final int blockIndex(long pos) {
        return Math.toIntExact(pos >> this.blockBits);
    }

    private final int blockOffset(long pos) {
        return (int)pos & this.blockMask;
    }

    private int blockSize() {
        return 1 << this.blockBits;
    }

    private static final boolean isPowerOfTwo(int v) {
        return (v & v - 1) == 0;
    }

    private static void ensureAssumptions(List<ByteBuffer> buffers) {
        if (buffers.isEmpty()) {
            throw new IllegalArgumentException("Buffer list must not be empty.");
        }
        if (buffers.size() != 1) {
            int blockPage = ByteBuffersDataInput.determineBlockPage(buffers);
            if (!ByteBuffersDataInput.isPowerOfTwo(blockPage)) {
                throw new IllegalArgumentException("The first buffer must have power-of-two position() + remaining(): 0x" + Integer.toHexString(blockPage));
            }
            int last = buffers.size() - 1;
            for (int i = 1; i < last; ++i) {
                ByteBuffer buffer = buffers.get(i);
                if (buffer.position() != 0) {
                    throw new IllegalArgumentException("All buffers except for the first one must have position() == 0: " + buffer);
                }
                if (i == last || buffer.remaining() == blockPage) continue;
                throw new IllegalArgumentException("Intermediate buffers must share an identical remaining() power-of-two block size: 0x" + Integer.toHexString(blockPage));
            }
        }
    }

    static int determineBlockPage(List<ByteBuffer> buffers) {
        ByteBuffer first = buffers.get(0);
        int blockPage = Math.toIntExact((long)first.position() + (long)first.remaining());
        return blockPage;
    }

    private static List<ByteBuffer> sliceBufferList(List<ByteBuffer> buffers, long offset, long length) {
        ByteBuffersDataInput.ensureAssumptions(buffers);
        if (buffers.size() == 1) {
            ByteBuffer cloned = buffers.get(0).asReadOnlyBuffer();
            cloned.position(Math.toIntExact((long)cloned.position() + offset));
            cloned.limit(Math.toIntExact((long)cloned.position() + length));
            return Arrays.asList(cloned);
        }
        long absStart = (long)buffers.get(0).position() + offset;
        long absEnd = absStart + length;
        int blockBytes = ByteBuffersDataInput.determineBlockPage(buffers);
        int blockBits = Integer.numberOfTrailingZeros(blockBytes);
        long blockMask = (1L << blockBits) - 1L;
        int endOffset = Math.toIntExact(absEnd & blockMask);
        ArrayList cloned = buffers.subList(Math.toIntExact(absStart / (long)blockBytes), Math.toIntExact(absEnd / (long)blockBytes + (long)(endOffset == 0 ? 0 : 1))).stream().map(buf -> buf.asReadOnlyBuffer()).collect(Collectors.toCollection(ArrayList::new));
        if (endOffset == 0) {
            cloned.add(ByteBuffer.allocate(0));
        }
        ((ByteBuffer)cloned.get(0)).position(Math.toIntExact(absStart & blockMask));
        ((ByteBuffer)cloned.get(cloned.size() - 1)).limit(endOffset);
        return cloned;
    }
}

