/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Membership;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;

public class Vector {
    public static final double MINIMUM_RESOLUTION = 1.0E-12;
    public static final double MINIMUM_ANGULAR_RESOLUTION = 3.141592653589793E-12;
    public static final double MINIMUM_RESOLUTION_SQUARED = 1.0E-24;
    public static final double MINIMUM_RESOLUTION_CUBED = 1.0E-36;
    public final double x;
    public final double y;
    public final double z;
    private static final double MINIMUM_GRAM_SCHMIDT_ENVELOPE = 5.0E-13;

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(Vector A, double BX, double BY, double BZ) {
        this(A.x, A.y, A.z, BX, BY, BZ);
    }

    public Vector(double AX, double AY, double AZ, double BX, double BY, double BZ) {
        double normalizeZ;
        double normalizeY;
        double normalizeX;
        block4: {
            double thisX = AY * BZ - AZ * BY;
            double thisY = AZ * BX - AX * BZ;
            double thisZ = AX * BY - AY * BX;
            double magnitude = Vector.magnitude(thisX, thisY, thisZ);
            if (magnitude == 0.0) {
                throw new IllegalArgumentException("Degenerate/parallel vector constructed");
            }
            double inverseMagnitude = 1.0 / magnitude;
            normalizeX = thisX * inverseMagnitude;
            normalizeY = thisY * inverseMagnitude;
            normalizeZ = thisZ * inverseMagnitude;
            int i = 0;
            do {
                double currentDotProd;
                double currentVectorZ;
                double currentVectorY;
                double currentVectorX;
                double currentDotProdA = AX * normalizeX + AY * normalizeY + AZ * normalizeZ;
                double currentDotProdB = BX * normalizeX + BY * normalizeY + BZ * normalizeZ;
                if (Math.abs(currentDotProdA) < 5.0E-13 && Math.abs(currentDotProdB) < 5.0E-13) break block4;
                if (Math.abs(currentDotProdA) > Math.abs(currentDotProdB)) {
                    currentVectorX = AX;
                    currentVectorY = AY;
                    currentVectorZ = AZ;
                    currentDotProd = currentDotProdA;
                } else {
                    currentVectorX = BX;
                    currentVectorY = BY;
                    currentVectorZ = BZ;
                    currentDotProd = currentDotProdB;
                }
                double correctedMagnitude = Vector.magnitude(normalizeX -= currentDotProd * currentVectorX, normalizeY -= currentDotProd * currentVectorY, normalizeZ -= currentDotProd * currentVectorZ);
                double inverseCorrectedMagnitude = 1.0 / correctedMagnitude;
                normalizeX *= inverseCorrectedMagnitude;
                normalizeY *= inverseCorrectedMagnitude;
                normalizeZ *= inverseCorrectedMagnitude;
            } while (i++ <= 10);
            throw new IllegalArgumentException("Plane could not be constructed! Could not find a normal vector.");
        }
        this.x = normalizeX;
        this.y = normalizeY;
        this.z = normalizeZ;
    }

    public Vector(Vector A, Vector B) {
        this(A, B.x, B.y, B.z);
    }

    public static double magnitude(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public Vector normalize() {
        double denom = this.magnitude();
        if (denom < 1.0E-12) {
            return null;
        }
        double normFactor = 1.0 / denom;
        return new Vector(this.x * normFactor, this.y * normFactor, this.z * normFactor);
    }

    public static boolean crossProductEvaluateIsZero(Vector A, Vector B, Vector point) {
        double normalizeZ;
        double normalizeY;
        double normalizeX;
        block4: {
            double thisX = A.y * B.z - A.z * B.y;
            double thisY = A.z * B.x - A.x * B.z;
            double thisZ = A.x * B.y - A.y * B.x;
            double magnitude = Vector.magnitude(thisX, thisY, thisZ);
            if (magnitude == 0.0) {
                return true;
            }
            double inverseMagnitude = 1.0 / magnitude;
            normalizeX = thisX * inverseMagnitude;
            normalizeY = thisY * inverseMagnitude;
            normalizeZ = thisZ * inverseMagnitude;
            int i = 0;
            do {
                double currentDotProd;
                double currentVectorZ;
                double currentVectorY;
                double currentVectorX;
                double currentDotProdA = A.x * normalizeX + A.y * normalizeY + A.z * normalizeZ;
                double currentDotProdB = B.x * normalizeX + B.y * normalizeY + B.z * normalizeZ;
                if (Math.abs(currentDotProdA) < 5.0E-13 && Math.abs(currentDotProdB) < 5.0E-13) break block4;
                if (Math.abs(currentDotProdA) > Math.abs(currentDotProdB)) {
                    currentVectorX = A.x;
                    currentVectorY = A.y;
                    currentVectorZ = A.z;
                    currentDotProd = currentDotProdA;
                } else {
                    currentVectorX = B.x;
                    currentVectorY = B.y;
                    currentVectorZ = B.z;
                    currentDotProd = currentDotProdB;
                }
                double correctedMagnitude = Vector.magnitude(normalizeX -= currentDotProd * currentVectorX, normalizeY -= currentDotProd * currentVectorY, normalizeZ -= currentDotProd * currentVectorZ);
                double inverseCorrectedMagnitude = 1.0 / correctedMagnitude;
                normalizeX *= inverseCorrectedMagnitude;
                normalizeY *= inverseCorrectedMagnitude;
                normalizeZ *= inverseCorrectedMagnitude;
            } while (i++ <= 10);
            throw new IllegalArgumentException("Plane could not be constructed! Could not find a normal vector.");
        }
        return Math.abs(normalizeX * point.x + normalizeY * point.y + normalizeZ * point.z) < 1.0E-12;
    }

    public double dotProduct(Vector v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public double dotProduct(double x, double y, double z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public boolean isWithin(Membership[] bounds, Membership ... moreBounds) {
        for (Membership bound : bounds) {
            if (bound == null || bound.isWithin(this)) continue;
            return false;
        }
        for (Membership bound : moreBounds) {
            if (bound == null || bound.isWithin(this)) continue;
            return false;
        }
        return true;
    }

    public Vector translate(double xOffset, double yOffset, double zOffset) {
        return new Vector(this.x - xOffset, this.y - yOffset, this.z - zOffset);
    }

    public Vector rotateXY(double angle) {
        return this.rotateXY(Math.sin(angle), Math.cos(angle));
    }

    public Vector rotateXY(double sinAngle, double cosAngle) {
        return new Vector(this.x * cosAngle - this.y * sinAngle, this.x * sinAngle + this.y * cosAngle, this.z);
    }

    public Vector rotateXZ(double angle) {
        return this.rotateXZ(Math.sin(angle), Math.cos(angle));
    }

    public Vector rotateXZ(double sinAngle, double cosAngle) {
        return new Vector(this.x * cosAngle - this.z * sinAngle, this.y, this.x * sinAngle + this.z * cosAngle);
    }

    public Vector rotateZY(double angle) {
        return this.rotateZY(Math.sin(angle), Math.cos(angle));
    }

    public Vector rotateZY(double sinAngle, double cosAngle) {
        return new Vector(this.x, this.z * sinAngle + this.y * cosAngle, this.z * cosAngle - this.y * sinAngle);
    }

    public double linearDistanceSquared(Vector v) {
        double deltaX = this.x - v.x;
        double deltaY = this.y - v.y;
        double deltaZ = this.z - v.z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public double linearDistanceSquared(double x, double y, double z) {
        double deltaX = this.x - x;
        double deltaY = this.y - y;
        double deltaZ = this.z - z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public double linearDistance(Vector v) {
        return Math.sqrt(this.linearDistanceSquared(v));
    }

    public double linearDistance(double x, double y, double z) {
        return Math.sqrt(this.linearDistanceSquared(x, y, z));
    }

    public double normalDistanceSquared(Vector v) {
        double t = this.dotProduct(v);
        double deltaX = this.x * t - v.x;
        double deltaY = this.y * t - v.y;
        double deltaZ = this.z * t - v.z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public double normalDistanceSquared(double x, double y, double z) {
        double t = this.dotProduct(x, y, z);
        double deltaX = this.x * t - x;
        double deltaY = this.y * t - y;
        double deltaZ = this.z * t - z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public double normalDistance(Vector v) {
        return Math.sqrt(this.normalDistanceSquared(v));
    }

    public double normalDistance(double x, double y, double z) {
        return Math.sqrt(this.normalDistanceSquared(x, y, z));
    }

    public double magnitude() {
        return Vector.magnitude(this.x, this.y, this.z);
    }

    public boolean isNumericallyIdentical(double otherX, double otherY, double otherZ) {
        double deltaX = this.x - otherX;
        double deltaY = this.y - otherY;
        double deltaZ = this.z - otherZ;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ < 1.0E-24;
    }

    public boolean isNumericallyIdentical(Vector other) {
        double deltaX = this.x - other.x;
        double deltaY = this.y - other.y;
        double deltaZ = this.z - other.z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ < 1.0E-24;
    }

    public boolean isParallel(double otherX, double otherY, double otherZ) {
        double thisX = this.y * otherZ - this.z * otherY;
        double thisY = this.z * otherX - this.x * otherZ;
        double thisZ = this.x * otherY - this.y * otherX;
        return thisX * thisX + thisY * thisY + thisZ * thisZ < 1.0E-24;
    }

    public boolean isParallel(Vector other) {
        double thisX = this.y * other.z - this.z * other.y;
        double thisY = this.z * other.x - this.x * other.z;
        double thisZ = this.x * other.y - this.y * other.x;
        return thisX * thisX + thisY * thisY + thisZ * thisZ < 1.0E-24;
    }

    static double computeDesiredEllipsoidMagnitude(PlanetModel planetModel, double x, double y, double z) {
        return 1.0 / Math.sqrt(x * x * planetModel.inverseXYScalingSquared + y * y * planetModel.inverseXYScalingSquared + z * z * planetModel.inverseZScalingSquared);
    }

    static double computeDesiredEllipsoidMagnitude(PlanetModel planetModel, double z) {
        return 1.0 / Math.sqrt((1.0 - z * z) * planetModel.inverseXYScalingSquared + z * z * planetModel.inverseZScalingSquared);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)o;
        return other.x == this.x && other.y == this.y && other.z == this.z;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "[X=" + this.x + ", Y=" + this.y + ", Z=" + this.z + "]";
    }
}

