/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.spatial4j;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.spatial4j.Geo3dRectangleShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoArea;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoAreaFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoAreaShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.LatLonBounds;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class Geo3dShape<T extends GeoAreaShape>
implements Shape {
    protected final SpatialContext spatialcontext;
    protected T shape;
    protected volatile Rectangle boundingBox = null;
    protected volatile Point center = null;

    public Geo3dShape(T shape, SpatialContext spatialcontext) {
        this.spatialcontext = spatialcontext;
        this.shape = shape;
    }

    public SpatialRelation relate(Shape other) {
        int relationship;
        if (other instanceof Geo3dShape) {
            relationship = this.relate((Geo3dShape)other);
        } else if (other instanceof Rectangle) {
            relationship = this.relate((Rectangle)other);
        } else if (other instanceof Point) {
            relationship = this.relate((Point)other);
        } else {
            throw new RuntimeException("Unimplemented shape relationship determination: " + other.getClass());
        }
        switch (relationship) {
            case 3: {
                return SpatialRelation.DISJOINT;
            }
            case 2: {
                return other instanceof Point ? SpatialRelation.CONTAINS : SpatialRelation.INTERSECTS;
            }
            case 0: {
                return other instanceof Point ? SpatialRelation.CONTAINS : SpatialRelation.WITHIN;
            }
            case 1: {
                return SpatialRelation.CONTAINS;
            }
        }
        throw new RuntimeException("Undetermined shape relationship: " + relationship);
    }

    private int relate(Geo3dShape<?> s) {
        return this.shape.getRelationship((GeoShape)s.shape);
    }

    private int relate(Rectangle r) {
        GeoArea geoArea = GeoAreaFactory.makeGeoArea(this.shape.getPlanetModel(), r.getMaxY() * (Math.PI / 180), r.getMinY() * (Math.PI / 180), r.getMinX() * (Math.PI / 180), r.getMaxX() * (Math.PI / 180));
        return geoArea.getRelationship((GeoShape)this.shape);
    }

    private int relate(Point p) {
        GeoPoint point = new GeoPoint(this.shape.getPlanetModel(), p.getY() * (Math.PI / 180), p.getX() * (Math.PI / 180));
        if (this.shape.isWithin(point)) {
            return 1;
        }
        return 3;
    }

    public Rectangle getBoundingBox() {
        Rectangle bbox = this.boundingBox;
        if (bbox == null) {
            LatLonBounds bounds = new LatLonBounds();
            this.shape.getBounds(bounds);
            GeoBBox geoBBox = GeoBBoxFactory.makeGeoBBox(this.shape.getPlanetModel(), bounds);
            this.boundingBox = bbox = new Geo3dRectangleShape(geoBBox, this.spatialcontext);
        }
        return bbox;
    }

    public boolean hasArea() {
        return true;
    }

    public double getArea(SpatialContext spatialContext) {
        throw new UnsupportedOperationException();
    }

    public Point getCenter() {
        Point center = this.center;
        if (center == null) {
            this.center = center = this.getBoundingBox().getCenter();
        }
        return center;
    }

    public Shape getBuffered(double distance, SpatialContext spatialContext) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return false;
    }

    public SpatialContext getContext() {
        return this.spatialcontext;
    }

    public String toString() {
        return "Geo3D:" + this.shape.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Geo3dShape)) {
            return false;
        }
        Geo3dShape other = (Geo3dShape)o;
        return other.spatialcontext.equals(this.spatialcontext) && other.shape.equals(this.shape);
    }

    public int hashCode() {
        return this.spatialcontext.hashCode() + this.shape.hashCode();
    }
}

