/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight;

import java.util.Arrays;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.Passage;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRefHash;

public class PassageScorer {
    final float k1;
    final float b;
    final float pivot;

    public PassageScorer() {
        this(1.2f, 0.75f, 87.0f);
    }

    public PassageScorer(float k1, float b, float pivot) {
        this.k1 = k1;
        this.b = b;
        this.pivot = pivot;
    }

    public float weight(int contentLength, int totalTermFreq) {
        float numDocs = 1.0f + (float)contentLength / this.pivot;
        return (this.k1 + 1.0f) * (float)Math.log(1.0 + ((double)numDocs + 0.5) / ((double)totalTermFreq + 0.5));
    }

    public float tf(int freq, int passageLen) {
        float norm = this.k1 * (1.0f - this.b + this.b * ((float)passageLen / this.pivot));
        return (float)freq / ((float)freq + norm);
    }

    public float norm(int passageStart) {
        return 1.0f + 1.0f / (float)Math.log(this.pivot + (float)passageStart);
    }

    public float score(Passage passage, int contentLength) {
        int i;
        float score = 0.0f;
        BytesRefHash termsHash = new BytesRefHash();
        int hitCount = passage.getNumMatches();
        int[] termFreqsInPassage = new int[hitCount];
        int[] termFreqsInDoc = new int[hitCount];
        Arrays.fill(termFreqsInPassage, 0);
        for (i = 0; i < passage.getNumMatches(); ++i) {
            int termIndex = termsHash.add(passage.getMatchTerms()[i]);
            if (termIndex < 0) {
                termIndex = -(termIndex + 1);
            } else {
                termFreqsInDoc[termIndex] = passage.getMatchTermFreqsInDoc()[i];
            }
            int n = termIndex;
            termFreqsInPassage[n] = termFreqsInPassage[n] + 1;
        }
        for (i = 0; i < termsHash.size(); ++i) {
            score += this.tf(termFreqsInPassage[i], passage.getLength()) * this.weight(contentLength, termFreqsInDoc[i]);
        }
        return score *= this.norm(passage.getStartOffset());
    }
}

