/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.ByteRunAutomaton;

public abstract class QueryVisitor {
    public static final QueryVisitor EMPTY_VISITOR = new QueryVisitor(){};

    public void consumeTerms(Query query, Term ... terms) {
    }

    public void consumeTermsMatching(Query query, String field, Supplier<ByteRunAutomaton> automaton) {
        this.visitLeaf(query);
    }

    public void visitLeaf(Query query) {
    }

    public boolean acceptField(String field) {
        return true;
    }

    public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
        if (occur == BooleanClause.Occur.MUST_NOT) {
            return EMPTY_VISITOR;
        }
        return this;
    }

    public static QueryVisitor termCollector(final Set<Term> termSet) {
        return new QueryVisitor(){

            @Override
            public void consumeTerms(Query query, Term ... terms) {
                termSet.addAll(Arrays.asList(terms));
            }
        };
    }
}

