/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.DocValuesProducer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentCommitInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountables;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RamUsageEstimator;

class SegmentDocValuesProducer
extends DocValuesProducer {
    private static final long LONG_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Long.class);
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentDocValuesProducer.class);
    final Map<String, DocValuesProducer> dvProducersByField = new HashMap<String, DocValuesProducer>();
    final Set<DocValuesProducer> dvProducers = Collections.newSetFromMap(new IdentityHashMap());
    final List<Long> dvGens = new ArrayList<Long>();

    SegmentDocValuesProducer(SegmentCommitInfo si, Directory dir, FieldInfos coreInfos, FieldInfos allInfos, SegmentDocValues segDocValues) throws IOException {
        try {
            DocValuesProducer baseProducer = null;
            for (FieldInfo fi : allInfos) {
                if (fi.getDocValuesType() == DocValuesType.NONE) continue;
                long docValuesGen = fi.getDocValuesGen();
                if (docValuesGen == -1L) {
                    if (baseProducer == null) {
                        baseProducer = segDocValues.getDocValuesProducer(docValuesGen, si, dir, coreInfos);
                        this.dvGens.add(docValuesGen);
                        this.dvProducers.add(baseProducer);
                    }
                    this.dvProducersByField.put(fi.name, baseProducer);
                    continue;
                }
                assert (!this.dvGens.contains(docValuesGen));
                DocValuesProducer dvp = segDocValues.getDocValuesProducer(docValuesGen, si, dir, new FieldInfos(new FieldInfo[]{fi}));
                this.dvGens.add(docValuesGen);
                this.dvProducers.add(dvp);
                this.dvProducersByField.put(fi.name, dvp);
            }
        }
        catch (Throwable t) {
            try {
                segDocValues.decRef(this.dvGens);
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getNumeric(field);
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getBinary(field);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getSorted(field);
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getSortedNumeric(field);
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getSortedSet(field);
    }

    @Override
    public void checkIntegrity() throws IOException {
        for (DocValuesProducer producer : this.dvProducers) {
            producer.checkIntegrity();
        }
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ramBytesUsed() {
        long ramBytesUsed = BASE_RAM_BYTES_USED;
        ramBytesUsed += (long)this.dvGens.size() * LONG_RAM_BYTES_USED;
        ramBytesUsed += (long)(this.dvProducers.size() * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        ramBytesUsed += (long)(this.dvProducersByField.size() * 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        for (DocValuesProducer producer : this.dvProducers) {
            ramBytesUsed += producer.ramBytesUsed();
        }
        return ramBytesUsed;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>(this.dvProducers.size());
        for (Accountable accountable : this.dvProducers) {
            resources.add(Accountables.namedAccountable("delegate", accountable));
        }
        return Collections.unmodifiableList(resources);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(producers=" + this.dvProducers.size() + ")";
    }
}

