/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.ShapeField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.ShapeQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Component2D;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.GeoUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Rectangle;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PointValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.FutureArrays;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.NumericUtils;

final class LatLonShapeBoundingBoxQuery
extends ShapeQuery {
    private final Rectangle rectangle;
    private final EncodedRectangle encodedRectangle;

    LatLonShapeBoundingBoxQuery(String field, ShapeField.QueryRelation queryRelation, Rectangle rectangle) {
        super(field, queryRelation);
        this.rectangle = rectangle;
        this.encodedRectangle = new EncodedRectangle(rectangle.minLat, rectangle.maxLat, rectangle.minLon, rectangle.maxLon);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        if (this.queryRelation == ShapeField.QueryRelation.INTERSECTS || this.queryRelation == ShapeField.QueryRelation.DISJOINT) {
            return this.encodedRectangle.intersectRangeBBox(minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        }
        return this.encodedRectangle.relateRangeBBox(minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
    }

    @Override
    protected boolean queryIntersects(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        switch (scratchTriangle.type) {
            case POINT: {
                return this.encodedRectangle.contains(scratchTriangle.aX, scratchTriangle.aY);
            }
            case LINE: {
                int aY = scratchTriangle.aY;
                int aX = scratchTriangle.aX;
                int bY = scratchTriangle.bY;
                int bX = scratchTriangle.bX;
                return this.encodedRectangle.intersectsLine(aX, aY, bX, bY);
            }
            case TRIANGLE: {
                int aY = scratchTriangle.aY;
                int aX = scratchTriangle.aX;
                int bY = scratchTriangle.bY;
                int bX = scratchTriangle.bX;
                int cY = scratchTriangle.cY;
                int cX = scratchTriangle.cX;
                return this.encodedRectangle.intersectsTriangle(aX, aY, bX, bY, cX, cY);
            }
        }
        throw new IllegalArgumentException("Unsupported triangle type :[" + (Object)((Object)scratchTriangle.type) + "]");
    }

    @Override
    protected boolean queryContains(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        switch (scratchTriangle.type) {
            case POINT: {
                return this.encodedRectangle.contains(scratchTriangle.aX, scratchTriangle.aY);
            }
            case LINE: {
                int aY = scratchTriangle.aY;
                int aX = scratchTriangle.aX;
                int bY = scratchTriangle.bY;
                int bX = scratchTriangle.bX;
                return this.encodedRectangle.containsLine(aX, aY, bX, bY);
            }
            case TRIANGLE: {
                int aY = scratchTriangle.aY;
                int aX = scratchTriangle.aX;
                int bY = scratchTriangle.bY;
                int bX = scratchTriangle.bX;
                int cY = scratchTriangle.cY;
                int cX = scratchTriangle.cX;
                return this.encodedRectangle.containsTriangle(aX, aY, bX, bY, cX, cY);
            }
        }
        throw new IllegalArgumentException("Unsupported triangle type :[" + (Object)((Object)scratchTriangle.type) + "]");
    }

    @Override
    protected Component2D.WithinRelation queryWithin(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        if (this.encodedRectangle.crossesDateline()) {
            throw new IllegalArgumentException("withinTriangle is not supported for rectangles crossing the date line");
        }
        ShapeField.decodeTriangle(t, scratchTriangle);
        switch (scratchTriangle.type) {
            case POINT: {
                return Component2D.WithinRelation.DISJOINT;
            }
            case LINE: {
                return this.encodedRectangle.withinLine(scratchTriangle.aX, scratchTriangle.aY, scratchTriangle.ab, scratchTriangle.bX, scratchTriangle.bY);
            }
            case TRIANGLE: {
                return this.encodedRectangle.withinTriangle(scratchTriangle.aX, scratchTriangle.aY, scratchTriangle.ab, scratchTriangle.bX, scratchTriangle.bY, scratchTriangle.bc, scratchTriangle.cX, scratchTriangle.cY, scratchTriangle.ca);
            }
        }
        throw new IllegalArgumentException("Unsupported triangle type :[" + (Object)((Object)scratchTriangle.type) + "]");
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && this.rectangle.equals(((LatLonShapeBoundingBoxQuery)o).rectangle);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.rectangle.hashCode();
        return hash;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.rectangle.toString());
        return sb.toString();
    }

    private static class EncodedRectangle {
        protected final byte[] bbox = new byte[16];
        private final byte[] west;
        protected final int minX;
        protected final int maxX;
        protected final int minY;
        protected final int maxY;
        private final boolean crossesDateline;

        EncodedRectangle(double minLat, double maxLat, double minLon, double maxLon) {
            int minXenc = GeoEncodingUtils.encodeLongitudeCeil(minLon);
            int maxXenc = GeoEncodingUtils.encodeLongitude(maxLon);
            int minYenc = GeoEncodingUtils.encodeLatitudeCeil(minLat);
            int maxYenc = GeoEncodingUtils.encodeLatitude(maxLat);
            if (minYenc > maxYenc) {
                minYenc = maxYenc;
            }
            this.minY = minYenc;
            this.maxY = maxYenc;
            if (minLon > maxLon) {
                this.crossesDateline = true;
                this.west = new byte[16];
                this.minX = minXenc;
                this.maxX = maxXenc;
                EncodedRectangle.encode(GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY, this.west);
                EncodedRectangle.encode(this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY, this.bbox);
            } else {
                this.crossesDateline = false;
                if (minXenc > maxXenc) {
                    minXenc = maxXenc;
                }
                this.west = null;
                this.minX = minXenc;
                this.maxX = maxXenc;
                EncodedRectangle.encode(this.minX, this.maxX, this.minY, this.maxY, this.bbox);
            }
        }

        private static void encode(int minX, int maxX, int minY, int maxY, byte[] b) {
            if (b == null) {
                b = new byte[16];
            }
            NumericUtils.intToSortableBytes(minY, b, 0);
            NumericUtils.intToSortableBytes(minX, b, 4);
            NumericUtils.intToSortableBytes(maxY, b, 8);
            NumericUtils.intToSortableBytes(maxX, b, 12);
        }

        private boolean crossesDateline() {
            return this.crossesDateline;
        }

        PointValues.Relation relateRangeBBox(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            PointValues.Relation eastRelation = EncodedRectangle.compareBBoxToRangeBBox(this.bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            if (this.crossesDateline() && eastRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return EncodedRectangle.compareBBoxToRangeBBox(this.west, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            }
            return eastRelation;
        }

        PointValues.Relation intersectRangeBBox(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            PointValues.Relation eastRelation = EncodedRectangle.intersectBBoxWithRangeBBox(this.bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            if (this.crossesDateline() && eastRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return EncodedRectangle.intersectBBoxWithRangeBBox(this.west, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            }
            return eastRelation;
        }

        private static PointValues.Relation compareBBoxToRangeBBox(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            if (EncodedRectangle.disjoint(bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle)) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (FutureArrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, bbox, 4, 8) >= 0 && FutureArrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, bbox, 12, 16) <= 0 && FutureArrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, bbox, 0, 4) >= 0 && FutureArrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, bbox, 8, 12) <= 0) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        private static PointValues.Relation intersectBBoxWithRangeBBox(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            if (EncodedRectangle.disjoint(bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle)) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (FutureArrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, bbox, 4, 8) >= 0 && FutureArrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, bbox, 0, 4) >= 0) {
                if (FutureArrays.compareUnsigned(maxTriangle, minXOffset, minXOffset + 4, bbox, 12, 16) <= 0 && FutureArrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, bbox, 8, 12) <= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                if (FutureArrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, bbox, 12, 16) <= 0 && FutureArrays.compareUnsigned(maxTriangle, minYOffset, minYOffset + 4, bbox, 8, 12) <= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            }
            if (FutureArrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, bbox, 12, 16) <= 0 && FutureArrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, bbox, 8, 12) <= 0) {
                if (FutureArrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, bbox, 4, 8) >= 0 && FutureArrays.compareUnsigned(minTriangle, maxYOffset, maxYOffset + 4, bbox, 0, 4) >= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                if (FutureArrays.compareUnsigned(minTriangle, maxXOffset, maxXOffset + 4, bbox, 4, 8) >= 0 && FutureArrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, bbox, 0, 4) >= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        private static boolean disjoint(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            return FutureArrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, bbox, 12, 16) > 0 || FutureArrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, bbox, 4, 8) < 0 || FutureArrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, bbox, 8, 12) > 0 || FutureArrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, bbox, 0, 4) < 0;
        }

        boolean contains(int x, int y) {
            if (y < this.minY || y > this.maxY) {
                return false;
            }
            if (this.crossesDateline()) {
                return !(x > this.maxX && x < this.minX);
            }
            return !(x > this.maxX || x < this.minX);
        }

        boolean intersectsLine(int aX, int aY, int bX, int bY) {
            if (this.contains(aX, aY) || this.contains(bX, bY)) {
                return true;
            }
            if (StrictMath.max(aY, bY) < this.minY || StrictMath.min(aY, bY) > this.maxY) {
                return false;
            }
            if (this.crossesDateline ? StrictMath.min(aX, bX) > this.maxX && StrictMath.max(aX, bX) < this.minX : StrictMath.min(aX, bX) > this.maxX || StrictMath.max(aX, bX) < this.minX) {
                return false;
            }
            return this.edgeIntersectsQuery(aX, aY, bX, bY);
        }

        boolean intersectsTriangle(int aX, int aY, int bX, int bY, int cX, int cY) {
            if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
                return true;
            }
            int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
            int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
            if (tMaxY < this.minY || tMinY > this.maxY) {
                return false;
            }
            int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
            int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
            if (this.crossesDateline ? tMinX > this.maxX && tMaxX < this.minX : tMinX > this.maxX || tMaxX < this.minX) {
                return false;
            }
            return Component2D.pointInTriangle(tMinX, tMaxX, tMinY, tMaxY, this.minX, this.minY, aX, aY, bX, bY, cX, cY) || this.edgeIntersectsQuery(aX, aY, bX, bY) || this.edgeIntersectsQuery(bX, bY, cX, cY) || this.edgeIntersectsQuery(cX, cY, aX, aY);
        }

        boolean containsLine(int aX, int aY, int bX, int bY) {
            if (aY < this.minY || bY < this.minY || aY > this.maxY || bY > this.maxY) {
                return false;
            }
            if (this.crossesDateline) {
                return aX >= this.minX && bX >= this.minX || aX <= this.maxX && bX <= this.maxX;
            }
            return aX >= this.minX && bX >= this.minX && aX <= this.maxX && bX <= this.maxX;
        }

        boolean containsTriangle(int aX, int aY, int bX, int bY, int cX, int cY) {
            if (aY < this.minY || bY < this.minY || cY < this.minY || aY > this.maxY || bY > this.maxY || cY > this.maxY) {
                return false;
            }
            if (this.crossesDateline) {
                return aX >= this.minX && bX >= this.minX && cX >= this.minX || aX <= this.maxX && bX <= this.maxX && cX <= this.maxX;
            }
            return aX >= this.minX && bX >= this.minX && cX >= this.minX && aX <= this.maxX && bX <= this.maxX && cX <= this.maxX;
        }

        Component2D.WithinRelation withinLine(int ax, int ay, boolean ab, int bx, int by) {
            if (ab && EncodedRectangle.edgeIntersectsBox(ax, ay, bx, by, this.minX, this.maxX, this.minY, this.maxY)) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            return Component2D.WithinRelation.DISJOINT;
        }

        Component2D.WithinRelation withinTriangle(int aX, int aY, boolean ab, int bX, int bY, boolean bc, int cX, int cY, boolean ca) {
            if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
            int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
            if (tMaxY < this.minY || tMinY > this.maxY) {
                return Component2D.WithinRelation.DISJOINT;
            }
            int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
            int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
            if (this.crossesDateline ? tMinX > this.maxX && tMaxX < this.minX : tMinX > this.maxX || tMaxX < this.minX) {
                return Component2D.WithinRelation.DISJOINT;
            }
            Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
            if (EncodedRectangle.edgeIntersectsBox(aX, aY, bX, bY, this.minX, this.maxX, this.minY, this.maxY)) {
                if (ab) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (EncodedRectangle.edgeIntersectsBox(bX, bY, cX, cY, this.minX, this.maxX, this.minY, this.maxY)) {
                if (bc) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (EncodedRectangle.edgeIntersectsBox(cX, cY, aX, aY, this.minX, this.maxX, this.minY, this.maxY)) {
                if (ca) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (relation == Component2D.WithinRelation.CANDIDATE || Component2D.pointInTriangle(tMinX, tMaxX, tMinY, tMaxY, this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
                return Component2D.WithinRelation.CANDIDATE;
            }
            return relation;
        }

        private boolean edgeIntersectsQuery(int aX, int aY, int bX, int bY) {
            if (this.crossesDateline) {
                return EncodedRectangle.edgeIntersectsBox(aX, aY, bX, bY, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || EncodedRectangle.edgeIntersectsBox(aX, aY, bX, bY, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
            }
            return EncodedRectangle.edgeIntersectsBox(aX, aY, bX, bY, this.minX, this.maxX, this.minY, this.maxY);
        }

        private static boolean edgeIntersectsBox(int aX, int aY, int bX, int bY, int minX, int maxX, int minY, int maxY) {
            if (Math.max(aX, bX) < minX || Math.min(aX, bX) > maxX || Math.min(aY, bY) > maxY || Math.max(aY, bY) < minY) {
                return false;
            }
            return GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, minX, maxY, maxX, maxY) || GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, maxX, maxY, maxX, minY) || GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, maxX, minY, minX, minY) || GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, minX, minY, minX, maxY);
        }
    }
}

