/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.compressing;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.compressing.CompressingStoredFieldsWriter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.compressing.FieldsIndex;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.compressing.FieldsIndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.compressing.LegacyFieldsIndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.StoredFieldVisitor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteArrayDataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.DataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountables;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BitUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.LongsRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.PackedInts;

public final class CompressingStoredFieldsReader
extends StoredFieldsReader {
    private final int version;
    private final FieldInfos fieldInfos;
    private final FieldsIndex indexReader;
    private final long maxPointer;
    private final IndexInput fieldsStream;
    private final int chunkSize;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final Decompressor decompressor;
    private final int numDocs;
    private final boolean merging;
    private final BlockState state;
    private final long numDirtyChunks;
    private final long numDirtyDocs;
    private boolean closed;

    private CompressingStoredFieldsReader(CompressingStoredFieldsReader reader, boolean merging) {
        this.version = reader.version;
        this.fieldInfos = reader.fieldInfos;
        this.fieldsStream = reader.fieldsStream.clone();
        this.indexReader = reader.indexReader.clone();
        this.maxPointer = reader.maxPointer;
        this.chunkSize = reader.chunkSize;
        this.packedIntsVersion = reader.packedIntsVersion;
        this.compressionMode = reader.compressionMode;
        this.decompressor = reader.decompressor.clone();
        this.numDocs = reader.numDocs;
        this.numDirtyChunks = reader.numDirtyChunks;
        this.numDirtyDocs = reader.numDirtyDocs;
        this.merging = merging;
        this.state = new BlockState();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompressingStoredFieldsReader(Directory d, SegmentInfo si, String segmentSuffix, FieldInfos fn, IOContext context, String formatName, CompressionMode compressionMode) throws IOException {
        this.compressionMode = compressionMode;
        String segment = si.name;
        boolean success = false;
        this.fieldInfos = fn;
        this.numDocs = si.maxDoc();
        String fieldsStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, "fdt");
        DataInput metaIn = null;
        try {
            void var14_19;
            this.fieldsStream = d.openInput(fieldsStreamFN, context);
            this.version = CodecUtil.checkIndexHeader(this.fieldsStream, formatName, 1, 3, si.getId(), segmentSuffix);
            assert ((long)CodecUtil.indexHeaderLength(formatName, segmentSuffix) == this.fieldsStream.getFilePointer());
            if (this.version >= 2) {
                String metaStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, "fdm");
                metaIn = d.openChecksumInput(metaStreamFN, IOContext.READONCE);
                CodecUtil.checkIndexHeader(metaIn, "Lucene85FieldsIndexMeta", 0, this.version, si.getId(), segmentSuffix);
            }
            if (this.version >= 3) {
                this.chunkSize = metaIn.readVInt();
                this.packedIntsVersion = metaIn.readVInt();
            } else {
                this.chunkSize = this.fieldsStream.readVInt();
                this.packedIntsVersion = this.fieldsStream.readVInt();
            }
            this.decompressor = compressionMode.newDecompressor();
            this.merging = false;
            this.state = new BlockState();
            CodecUtil.retrieveChecksum(this.fieldsStream);
            long maxPointer = -1L;
            Object var14_15 = null;
            if (this.version < 2) {
                String indexName = IndexFileNames.segmentFileName(segment, segmentSuffix, "fdx");
                try (ChecksumIndexInput indexStream = d.openChecksumInput(indexName, context);){
                    Throwable priorE = null;
                    try {
                        assert (formatName.endsWith("Data"));
                        String codecNameIdx = formatName.substring(0, formatName.length() - "Data".length()) + "Index";
                        int version2 = CodecUtil.checkIndexHeader(indexStream, codecNameIdx, 1, 3, si.getId(), segmentSuffix);
                        if (this.version != version2) {
                            throw new CorruptIndexException("Version mismatch between stored fields index and data: " + version2 + " != " + this.version, indexStream);
                        }
                        assert ((long)CodecUtil.indexHeaderLength(codecNameIdx, segmentSuffix) == indexStream.getFilePointer());
                        LegacyFieldsIndexReader legacyFieldsIndexReader = new LegacyFieldsIndexReader(indexStream, si);
                        maxPointer = indexStream.readVLong();
                    }
                    catch (Throwable exception) {
                        try {
                            priorE = exception;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            CodecUtil.checkFooter(indexStream, priorE);
                        }
                    }
                    CodecUtil.checkFooter(indexStream, priorE);
                }
            } else {
                FieldsIndexReader fieldsIndexReader;
                FieldsIndexReader fieldsIndexReader2 = fieldsIndexReader = new FieldsIndexReader(d, si.name, segmentSuffix, "fdx", "Lucene85FieldsIndex", si.getId(), (IndexInput)metaIn);
                maxPointer = fieldsIndexReader.getMaxPointer();
            }
            this.maxPointer = maxPointer;
            this.indexReader = var14_19;
            if (this.version >= 3) {
                this.numDirtyChunks = metaIn.readVLong();
                this.numDirtyDocs = metaIn.readVLong();
            } else {
                this.numDirtyDocs = -1L;
                this.numDirtyChunks = -1L;
            }
            if (metaIn != null) {
                CodecUtil.checkFooter((ChecksumIndexInput)metaIn, null);
                ((IndexInput)metaIn).close();
            }
            if (success = true) return;
        }
        catch (Throwable t) {
            try {
                if (metaIn == null) throw t;
                CodecUtil.checkFooter(metaIn, t);
                throw new AssertionError((Object)"unreachable");
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(new Closeable[]{this, metaIn});
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(new Closeable[]{this, metaIn});
        return;
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.indexReader, this.fieldsStream);
            this.closed = true;
        }
    }

    private static void readField(DataInput in, StoredFieldVisitor visitor, FieldInfo info, int bits) throws IOException {
        switch (bits & CompressingStoredFieldsWriter.TYPE_MASK) {
            case 1: {
                int length = in.readVInt();
                byte[] data = new byte[length];
                in.readBytes(data, 0, length);
                visitor.binaryField(info, data);
                break;
            }
            case 0: {
                int length = in.readVInt();
                byte[] data = new byte[length];
                in.readBytes(data, 0, length);
                visitor.stringField(info, data);
                break;
            }
            case 2: {
                visitor.intField(info, in.readZInt());
                break;
            }
            case 3: {
                visitor.floatField(info, CompressingStoredFieldsReader.readZFloat(in));
                break;
            }
            case 4: {
                visitor.longField(info, CompressingStoredFieldsReader.readTLong(in));
                break;
            }
            case 5: {
                visitor.doubleField(info, CompressingStoredFieldsReader.readZDouble(in));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    private static void skipField(DataInput in, int bits) throws IOException {
        switch (bits & CompressingStoredFieldsWriter.TYPE_MASK) {
            case 0: 
            case 1: {
                int length = in.readVInt();
                in.skipBytes(length);
                break;
            }
            case 2: {
                in.readZInt();
                break;
            }
            case 3: {
                CompressingStoredFieldsReader.readZFloat(in);
                break;
            }
            case 4: {
                CompressingStoredFieldsReader.readTLong(in);
                break;
            }
            case 5: {
                CompressingStoredFieldsReader.readZDouble(in);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    static float readZFloat(DataInput in) throws IOException {
        int b = in.readByte() & 0xFF;
        if (b == 255) {
            return Float.intBitsToFloat(in.readInt());
        }
        if ((b & 0x80) != 0) {
            return (b & 0x7F) - 1;
        }
        int bits = b << 24 | (in.readShort() & 0xFFFF) << 8 | in.readByte() & 0xFF;
        return Float.intBitsToFloat(bits);
    }

    static double readZDouble(DataInput in) throws IOException {
        int b = in.readByte() & 0xFF;
        if (b == 255) {
            return Double.longBitsToDouble(in.readLong());
        }
        if (b == 254) {
            return Float.intBitsToFloat(in.readInt());
        }
        if ((b & 0x80) != 0) {
            return (b & 0x7F) - 1;
        }
        long bits = (long)b << 56 | ((long)in.readInt() & 0xFFFFFFFFL) << 24 | ((long)in.readShort() & 0xFFFFL) << 8 | (long)in.readByte() & 0xFFL;
        return Double.longBitsToDouble(bits);
    }

    static long readTLong(DataInput in) throws IOException {
        int header = in.readByte() & 0xFF;
        long bits = header & 0x1F;
        if ((header & 0x20) != 0) {
            bits |= in.readVLong() << 5;
        }
        long l = BitUtil.zigZagDecode(bits);
        switch (header & 0xC0) {
            case 64: {
                l *= 1000L;
                break;
            }
            case 128: {
                l *= 3600000L;
                break;
            }
            case 192: {
                l *= 86400000L;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return l;
    }

    SerializedDocument document(int docID) throws IOException {
        if (!this.state.contains(docID)) {
            this.fieldsStream.seek(this.indexReader.getStartPointer(docID));
            this.state.reset(docID);
        }
        assert (this.state.contains(docID));
        return this.state.document(docID);
    }

    @Override
    public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
        SerializedDocument doc = this.document(docID);
        block5: for (int fieldIDX = 0; fieldIDX < doc.numStoredFields; ++fieldIDX) {
            long infoAndBits = doc.in.readVLong();
            int fieldNumber = (int)(infoAndBits >>> CompressingStoredFieldsWriter.TYPE_BITS);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
            int bits = (int)(infoAndBits & (long)CompressingStoredFieldsWriter.TYPE_MASK);
            assert (bits <= 5) : "bits=" + Integer.toHexString(bits);
            switch (visitor.needsField(fieldInfo)) {
                case YES: {
                    CompressingStoredFieldsReader.readField(doc.in, visitor, fieldInfo, bits);
                    continue block5;
                }
                case NO: {
                    if (fieldIDX == doc.numStoredFields - 1) {
                        return;
                    }
                    CompressingStoredFieldsReader.skipField(doc.in, bits);
                    continue block5;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    @Override
    public StoredFieldsReader clone() {
        this.ensureOpen();
        return new CompressingStoredFieldsReader(this, false);
    }

    @Override
    public StoredFieldsReader getMergeInstance() {
        this.ensureOpen();
        return new CompressingStoredFieldsReader(this, true);
    }

    int getVersion() {
        return this.version;
    }

    CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    FieldsIndex getIndexReader() {
        return this.indexReader;
    }

    long getMaxPointer() {
        return this.maxPointer;
    }

    IndexInput getFieldsStream() {
        return this.fieldsStream;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    long getNumDirtyDocs() {
        if (this.version != 3) {
            throw new IllegalStateException("getNumDirtyDocs should only ever get called when the reader is on the current version");
        }
        assert (this.numDirtyDocs >= 0L);
        return this.numDirtyDocs;
    }

    long getNumDirtyChunks() {
        if (this.version != 3) {
            throw new IllegalStateException("getNumDirtyChunks should only ever get called when the reader is on the current version");
        }
        assert (this.numDirtyChunks >= 0L);
        return this.numDirtyChunks;
    }

    int getNumDocs() {
        return this.numDocs;
    }

    int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    @Override
    public long ramBytesUsed() {
        return this.indexReader.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.singleton(Accountables.namedAccountable("stored field index", this.indexReader));
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.indexReader.checkIntegrity();
        CodecUtil.checksumEntireFile(this.fieldsStream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    private class BlockState {
        private int docBase;
        private int chunkDocs;
        private boolean sliced;
        private long[] offsets = LongsRef.EMPTY_LONGS;
        private long[] numStoredFields = LongsRef.EMPTY_LONGS;
        private long startPointer;
        private final BytesRef spare;
        private final BytesRef bytes;

        BlockState() {
            if (CompressingStoredFieldsReader.this.merging) {
                this.spare = new BytesRef();
                this.bytes = new BytesRef();
            } else {
                this.bytes = null;
                this.spare = null;
            }
        }

        boolean contains(int docID) {
            return docID >= this.docBase && docID < this.docBase + this.chunkDocs;
        }

        void reset(int docID) throws IOException {
            boolean success = false;
            try {
                this.doReset(docID);
                success = true;
            }
            finally {
                if (!success) {
                    this.chunkDocs = 0;
                }
            }
        }

        private void doReset(int docID) throws IOException {
            this.docBase = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            int token = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            this.chunkDocs = token >>> 1;
            if (!this.contains(docID) || this.docBase + this.chunkDocs > CompressingStoredFieldsReader.this.numDocs) {
                throw new CorruptIndexException("Corrupted: docID=" + docID + ", docBase=" + this.docBase + ", chunkDocs=" + this.chunkDocs + ", numDocs=" + CompressingStoredFieldsReader.this.numDocs, CompressingStoredFieldsReader.this.fieldsStream);
            }
            this.sliced = (token & 1) != 0;
            this.offsets = ArrayUtil.grow(this.offsets, this.chunkDocs + 1);
            this.numStoredFields = ArrayUtil.grow(this.numStoredFields, this.chunkDocs);
            if (this.chunkDocs == 1) {
                this.numStoredFields[0] = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                this.offsets[1] = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            } else {
                int i;
                int bitsPerStoredFields = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (bitsPerStoredFields == 0) {
                    Arrays.fill(this.numStoredFields, 0, this.chunkDocs, (long)CompressingStoredFieldsReader.this.fieldsStream.readVInt());
                } else {
                    LongsRef next;
                    if (bitsPerStoredFields > 31) {
                        throw new CorruptIndexException("bitsPerStoredFields=" + bitsPerStoredFields, CompressingStoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, CompressingStoredFieldsReader.this.packedIntsVersion, this.chunkDocs, bitsPerStoredFields, 1024);
                    for (int i2 = 0; i2 < this.chunkDocs; i2 += next.length) {
                        next = it.next(Integer.MAX_VALUE);
                        System.arraycopy(next.longs, next.offset, this.numStoredFields, i2, next.length);
                    }
                }
                int bitsPerLength = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (bitsPerLength == 0) {
                    int length = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                    for (i = 0; i < this.chunkDocs; ++i) {
                        this.offsets[1 + i] = (1 + i) * length;
                    }
                } else {
                    LongsRef next;
                    if (bitsPerStoredFields > 31) {
                        throw new CorruptIndexException("bitsPerLength=" + bitsPerLength, CompressingStoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, CompressingStoredFieldsReader.this.packedIntsVersion, this.chunkDocs, bitsPerLength, 1024);
                    for (i = 0; i < this.chunkDocs; i += next.length) {
                        next = it.next(Integer.MAX_VALUE);
                        System.arraycopy(next.longs, next.offset, this.offsets, i + 1, next.length);
                    }
                    for (i = 0; i < this.chunkDocs; ++i) {
                        int n = i + 1;
                        this.offsets[n] = this.offsets[n] + this.offsets[i];
                    }
                }
                for (int i3 = 0; i3 < this.chunkDocs; ++i3) {
                    long storedFields;
                    long len = this.offsets[i3 + 1] - this.offsets[i3];
                    if (len == 0L == ((storedFields = this.numStoredFields[i3]) == 0L)) continue;
                    throw new CorruptIndexException("length=" + len + ", numStoredFields=" + storedFields, CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
            this.startPointer = CompressingStoredFieldsReader.this.fieldsStream.getFilePointer();
            if (CompressingStoredFieldsReader.this.merging) {
                int totalLength = Math.toIntExact(this.offsets[this.chunkDocs]);
                if (this.sliced) {
                    int toDecompress;
                    this.bytes.length = 0;
                    this.bytes.offset = 0;
                    for (int decompressed = 0; decompressed < totalLength; decompressed += toDecompress) {
                        toDecompress = Math.min(totalLength - decompressed, CompressingStoredFieldsReader.this.chunkSize);
                        CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, this.spare);
                        this.bytes.bytes = ArrayUtil.grow(this.bytes.bytes, this.bytes.length + this.spare.length);
                        System.arraycopy(this.spare.bytes, this.spare.offset, this.bytes.bytes, this.bytes.length, this.spare.length);
                        this.bytes.length += this.spare.length;
                    }
                } else {
                    CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, totalLength, 0, totalLength, this.bytes);
                }
                if (this.bytes.length != totalLength) {
                    throw new CorruptIndexException("Corrupted: expected chunk size = " + totalLength + ", got " + this.bytes.length, CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
        }

        SerializedDocument document(int docID) throws IOException {
            DataInput documentInput;
            if (!this.contains(docID)) {
                throw new IllegalArgumentException();
            }
            int index = docID - this.docBase;
            int offset = Math.toIntExact(this.offsets[index]);
            final int length = Math.toIntExact(this.offsets[index + 1]) - offset;
            int totalLength = Math.toIntExact(this.offsets[this.chunkDocs]);
            int numStoredFields = Math.toIntExact(this.numStoredFields[index]);
            final BytesRef bytes = CompressingStoredFieldsReader.this.merging ? this.bytes : new BytesRef();
            if (length == 0) {
                documentInput = new ByteArrayDataInput();
            } else if (CompressingStoredFieldsReader.this.merging) {
                documentInput = new ByteArrayDataInput(bytes.bytes, bytes.offset + offset, length);
            } else if (this.sliced) {
                CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, CompressingStoredFieldsReader.this.chunkSize, offset, Math.min(length, CompressingStoredFieldsReader.this.chunkSize - offset), bytes);
                documentInput = new DataInput(){
                    int decompressed;
                    {
                        this.decompressed = bytes.length;
                    }

                    void fillBuffer() throws IOException {
                        assert (this.decompressed <= length);
                        if (this.decompressed == length) {
                            throw new EOFException();
                        }
                        int toDecompress = Math.min(length - this.decompressed, CompressingStoredFieldsReader.this.chunkSize);
                        CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, bytes);
                        this.decompressed += toDecompress;
                    }

                    @Override
                    public byte readByte() throws IOException {
                        if (bytes.length == 0) {
                            this.fillBuffer();
                        }
                        --bytes.length;
                        return bytes.bytes[bytes.offset++];
                    }

                    @Override
                    public void readBytes(byte[] b, int offset, int len) throws IOException {
                        while (len > bytes.length) {
                            System.arraycopy(bytes.bytes, bytes.offset, b, offset, bytes.length);
                            len -= bytes.length;
                            offset += bytes.length;
                            this.fillBuffer();
                        }
                        System.arraycopy(bytes.bytes, bytes.offset, b, offset, len);
                        bytes.offset += len;
                        bytes.length -= len;
                    }
                };
            } else {
                CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, totalLength, offset, length, bytes);
                assert (bytes.length == length);
                documentInput = new ByteArrayDataInput(bytes.bytes, bytes.offset, bytes.length);
            }
            return new SerializedDocument(documentInput, length, numStoredFields);
        }
    }

    static class SerializedDocument {
        final DataInput in;
        final int length;
        final int numStoredFields;

        private SerializedDocument(DataInput in, int length, int numStoredFields) {
            this.in = in;
            this.length = length;
            this.numStoredFields = numStoredFields;
        }
    }
}

