/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.LightWeightGSet;

public class INodeMap {
    private final GSet<INode, INodeWithAdditionalFields> map;

    static INodeMap newInstance(INodeDirectory rootDir) {
        int capacity = LightWeightGSet.computeCapacity(1.0, "INodeMap");
        LightWeightGSet<INode, INodeWithAdditionalFields> map = new LightWeightGSet<INode, INodeWithAdditionalFields>(capacity);
        map.put(rootDir);
        return new INodeMap(map);
    }

    public Iterator<INodeWithAdditionalFields> getMapIterator() {
        return this.map.iterator();
    }

    private INodeMap(GSet<INode, INodeWithAdditionalFields> map) {
        Preconditions.checkArgument(map != null);
        this.map = map;
    }

    public final void put(INode inode) {
        if (inode instanceof INodeWithAdditionalFields) {
            this.map.put((INodeWithAdditionalFields)inode);
        }
    }

    public final void remove(INode inode) {
        this.map.remove(inode);
    }

    public int size() {
        return this.map.size();
    }

    public INode get(long id) {
        INodeWithAdditionalFields inode = new INodeWithAdditionalFields(id, null, new PermissionStatus("", "", new FsPermission(0)), 0L, 0L){

            @Override
            void recordModification(int latestSnapshotId) {
            }

            @Override
            public void destroyAndCollectBlocks(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            }

            @Override
            public QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, QuotaCounts counts, boolean useCache, int lastSnapshotId) {
                return null;
            }

            @Override
            public ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext summary) {
                return null;
            }

            @Override
            public QuotaCounts cleanSubtree(BlockStoragePolicySuite bsps, int snapshotId, int priorSnapshotId, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
                return null;
            }

            @Override
            public byte getStoragePolicyID() {
                return 0;
            }

            @Override
            public byte getLocalStoragePolicyID() {
                return 0;
            }
        };
        return this.map.get(inode);
    }

    public void clear() {
        this.map.clear();
    }
}

