/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.io.netty.handler.codec.serialization;

import java.util.Map;
import org.apache.flink.hadoop.shaded.io.netty.handler.codec.serialization.ClassResolver;

class CachingClassResolver
implements ClassResolver {
    private final Map<String, Class<?>> classCache;
    private final ClassResolver delegate;

    CachingClassResolver(ClassResolver delegate, Map<String, Class<?>> classCache) {
        this.delegate = delegate;
        this.classCache = classCache;
    }

    @Override
    public Class<?> resolve(String className) throws ClassNotFoundException {
        Class<?> clazz = this.classCache.get(className);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.delegate.resolve(className);
        this.classCache.put(className, clazz);
        return clazz;
    }
}

