/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.com.google.common.hash;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.hadoop.shaded.com.google.common.hash.AbstractStreamingHashFunction;
import org.apache.flink.hadoop.shaded.com.google.common.hash.HashCode;
import org.apache.flink.hadoop.shaded.com.google.common.hash.HashCodes;
import org.apache.flink.hadoop.shaded.com.google.common.hash.Hasher;
import org.apache.flink.hadoop.shaded.com.google.common.primitives.UnsignedBytes;

final class Murmur3_128HashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_128HashFunction(int seed) {
        this.seed = seed;
    }

    public int bits() {
        return 128;
    }

    public Hasher newHasher() {
        return new Murmur3_128Hasher(this.seed);
    }

    private static final class Murmur3_128Hasher
    extends AbstractStreamingHashFunction.AbstractStreamingHasher {
        long h1;
        long h2;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int len;

        Murmur3_128Hasher(int seed) {
            super(16);
            this.h1 = seed;
            this.h2 = seed;
        }

        protected void process(ByteBuffer bb) {
            long k1 = bb.getLong();
            long k2 = bb.getLong();
            this.len += 16;
            this.bmix64(k1, k2);
        }

        private void bmix64(long k1, long k2) {
            k1 *= this.c1;
            k1 = Long.rotateLeft(k1, 31);
            this.h1 ^= (k1 *= this.c2);
            this.h1 = Long.rotateLeft(this.h1, 27);
            this.h1 += this.h2;
            this.h1 = this.h1 * 5L + 1390208809L;
            k2 *= this.c2;
            k2 = Long.rotateLeft(k2, 33);
            this.h2 ^= (k2 *= this.c1);
            this.h2 = Long.rotateLeft(this.h2, 31);
            this.h2 += this.h1;
            this.h2 = this.h2 * 5L + 944331445L;
        }

        protected void processRemaining(ByteBuffer bb) {
            long k1 = 0L;
            long k2 = 0L;
            this.len += bb.remaining();
            switch (bb.remaining()) {
                case 15: {
                    k2 ^= (long)UnsignedBytes.toInt(bb.get(14)) << 48;
                }
                case 14: {
                    k2 ^= (long)UnsignedBytes.toInt(bb.get(13)) << 40;
                }
                case 13: {
                    k2 ^= (long)UnsignedBytes.toInt(bb.get(12)) << 32;
                }
                case 12: {
                    k2 ^= (long)UnsignedBytes.toInt(bb.get(11)) << 24;
                }
                case 11: {
                    k2 ^= (long)UnsignedBytes.toInt(bb.get(10)) << 16;
                }
                case 10: {
                    k2 ^= (long)UnsignedBytes.toInt(bb.get(9)) << 8;
                }
                case 9: {
                    k2 ^= (long)UnsignedBytes.toInt(bb.get(8)) << 0;
                    k2 *= this.c2;
                    k2 = Long.rotateLeft(k2, 33);
                    this.h2 ^= (k2 *= this.c1);
                }
                case 8: {
                    k1 ^= (long)UnsignedBytes.toInt(bb.get(7)) << 56;
                }
                case 7: {
                    k1 ^= (long)UnsignedBytes.toInt(bb.get(6)) << 48;
                }
                case 6: {
                    k1 ^= (long)UnsignedBytes.toInt(bb.get(5)) << 40;
                }
                case 5: {
                    k1 ^= (long)UnsignedBytes.toInt(bb.get(4)) << 32;
                }
                case 4: {
                    k1 ^= (long)UnsignedBytes.toInt(bb.get(3)) << 24;
                }
                case 3: {
                    k1 ^= (long)UnsignedBytes.toInt(bb.get(2)) << 16;
                }
                case 2: {
                    k1 ^= (long)UnsignedBytes.toInt(bb.get(1)) << 8;
                }
                case 1: {
                    k1 ^= (long)UnsignedBytes.toInt(bb.get(0)) << 0;
                    k1 *= this.c1;
                    k1 = Long.rotateLeft(k1, 31);
                    this.h1 ^= (k1 *= this.c2);
                }
            }
        }

        public HashCode makeHash() {
            this.h1 ^= (long)this.len;
            this.h2 ^= (long)this.len;
            this.h1 += this.h2;
            this.h2 += this.h1;
            this.h1 = this.fmix64(this.h1);
            this.h2 = this.fmix64(this.h2);
            this.h1 += this.h2;
            this.h2 += this.h1;
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]).order(ByteOrder.LITTLE_ENDIAN);
            bb.putLong(this.h1);
            bb.putLong(this.h2);
            return HashCodes.fromBytes(bb.array());
        }

        private long fmix64(long k) {
            k ^= k >>> 33;
            k *= -49064778989728563L;
            k ^= k >>> 33;
            k *= -4265267296055464877L;
            k ^= k >>> 33;
            return k;
        }
    }
}

