/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.io.ParsingDecoder;
import org.apache.avro.io.parsing.JsonGrammarGenerator;
import org.apache.avro.io.parsing.Parser;
import org.apache.avro.io.parsing.Symbol;
import org.apache.avro.util.Utf8;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.Base64Variant;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonFactory;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonLocation;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonParser;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonStreamContext;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonToken;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.ObjectCodec;

public class JsonDecoder
extends ParsingDecoder
implements Parser.ActionHandler {
    private JsonParser in;
    private static JsonFactory jsonFactory = new JsonFactory();
    Stack<ReorderBuffer> reorderBuffers = new Stack();
    ReorderBuffer currentReorderBuffer;
    static final String CHARSET = "ISO-8859-1";

    private JsonDecoder(Symbol root, InputStream in) throws IOException {
        super(root);
        this.configure(in);
    }

    private JsonDecoder(Symbol root, String in) throws IOException {
        super(root);
        this.configure(in);
    }

    JsonDecoder(Schema schema, InputStream in) throws IOException {
        this(JsonDecoder.getSymbol(schema), in);
    }

    JsonDecoder(Schema schema, String in) throws IOException {
        this(JsonDecoder.getSymbol(schema), in);
    }

    private static Symbol getSymbol(Schema schema) {
        if (null == schema) {
            throw new NullPointerException("Schema cannot be null!");
        }
        return new JsonGrammarGenerator().generate(schema);
    }

    public JsonDecoder configure(InputStream in) throws IOException {
        if (null == in) {
            throw new NullPointerException("InputStream to read from cannot be null!");
        }
        this.parser.reset();
        this.in = jsonFactory.createJsonParser(in);
        this.in.nextToken();
        return this;
    }

    public JsonDecoder configure(String in) throws IOException {
        if (null == in) {
            throw new NullPointerException("String to read from cannot be null!");
        }
        this.parser.reset();
        this.in = new JsonFactory().createJsonParser(in);
        this.in.nextToken();
        return this;
    }

    private void advance(Symbol symbol) throws IOException {
        this.parser.processTrailingImplicitActions();
        if (this.in.getCurrentToken() == null && this.parser.depth() == 1) {
            throw new EOFException();
        }
        this.parser.advance(symbol);
    }

    @Override
    public void readNull() throws IOException {
        this.advance(Symbol.NULL);
        if (this.in.getCurrentToken() != JsonToken.VALUE_NULL) {
            throw this.error("null");
        }
        this.in.nextToken();
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.advance(Symbol.BOOLEAN);
        JsonToken t = this.in.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE || t == JsonToken.VALUE_FALSE) {
            this.in.nextToken();
            return t == JsonToken.VALUE_TRUE;
        }
        throw this.error("boolean");
    }

    @Override
    public int readInt() throws IOException {
        this.advance(Symbol.INT);
        if (this.in.getCurrentToken().isNumeric()) {
            int result = this.in.getIntValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("int");
    }

    @Override
    public long readLong() throws IOException {
        this.advance(Symbol.LONG);
        if (this.in.getCurrentToken().isNumeric()) {
            long result = this.in.getLongValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("long");
    }

    @Override
    public float readFloat() throws IOException {
        this.advance(Symbol.FLOAT);
        if (this.in.getCurrentToken().isNumeric()) {
            float result = this.in.getFloatValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("float");
    }

    @Override
    public double readDouble() throws IOException {
        this.advance(Symbol.DOUBLE);
        if (this.in.getCurrentToken().isNumeric()) {
            double result = this.in.getDoubleValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("double");
    }

    @Override
    public Utf8 readString(Utf8 old) throws IOException {
        return new Utf8(this.readString());
    }

    @Override
    public String readString() throws IOException {
        this.advance(Symbol.STRING);
        if (this.parser.topSymbol() == Symbol.MAP_KEY_MARKER) {
            this.parser.advance(Symbol.MAP_KEY_MARKER);
            if (this.in.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw this.error("map-key");
            }
        } else if (this.in.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw this.error("string");
        }
        String result = this.in.getText();
        this.in.nextToken();
        return result;
    }

    @Override
    public void skipString() throws IOException {
        this.advance(Symbol.STRING);
        if (this.parser.topSymbol() == Symbol.MAP_KEY_MARKER) {
            this.parser.advance(Symbol.MAP_KEY_MARKER);
            if (this.in.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw this.error("map-key");
            }
        } else if (this.in.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw this.error("string");
        }
        this.in.nextToken();
    }

    @Override
    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        this.advance(Symbol.BYTES);
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            byte[] result = this.readByteArray();
            this.in.nextToken();
            return ByteBuffer.wrap(result);
        }
        throw this.error("bytes");
    }

    private byte[] readByteArray() throws IOException {
        byte[] result = this.in.getText().getBytes(CHARSET);
        return result;
    }

    @Override
    public void skipBytes() throws IOException {
        this.advance(Symbol.BYTES);
        if (this.in.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw this.error("bytes");
        }
        this.in.nextToken();
    }

    private void checkFixed(int size) throws IOException {
        this.advance(Symbol.FIXED);
        Symbol.IntCheckAction top = (Symbol.IntCheckAction)this.parser.popSymbol();
        if (size != top.size) {
            throw new AvroTypeException("Incorrect length for fixed binary: expected " + top.size + " but received " + size + " bytes.");
        }
    }

    @Override
    public void readFixed(byte[] bytes, int start, int len) throws IOException {
        byte[] result;
        this.checkFixed(len);
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            result = this.readByteArray();
            this.in.nextToken();
            if (result.length != len) {
                throw new AvroTypeException("Expected fixed length " + len + ", but got" + result.length);
            }
        } else {
            throw this.error("fixed");
        }
        System.arraycopy(result, 0, bytes, start, len);
    }

    @Override
    public void skipFixed(int length) throws IOException {
        this.checkFixed(length);
        this.doSkipFixed(length);
    }

    private void doSkipFixed(int length) throws IOException {
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            byte[] result = this.readByteArray();
            this.in.nextToken();
            if (result.length != length) {
                throw new AvroTypeException("Expected fixed length " + length + ", but got" + result.length);
            }
        } else {
            throw this.error("fixed");
        }
    }

    @Override
    protected void skipFixed() throws IOException {
        this.advance(Symbol.FIXED);
        Symbol.IntCheckAction top = (Symbol.IntCheckAction)this.parser.popSymbol();
        this.doSkipFixed(top.size);
    }

    @Override
    public int readEnum() throws IOException {
        this.advance(Symbol.ENUM);
        Symbol.EnumLabelsAction top = (Symbol.EnumLabelsAction)this.parser.popSymbol();
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            this.in.getText();
            int n = top.findLabel(this.in.getText());
            if (n >= 0) {
                this.in.nextToken();
                return n;
            }
            throw new AvroTypeException("Unknown symbol in enum " + this.in.getText());
        }
        throw this.error("fixed");
    }

    @Override
    public long readArrayStart() throws IOException {
        this.advance(Symbol.ARRAY_START);
        if (this.in.getCurrentToken() == JsonToken.START_ARRAY) {
            this.in.nextToken();
            return this.doArrayNext();
        }
        throw this.error("array-start");
    }

    @Override
    public long arrayNext() throws IOException {
        this.advance(Symbol.ITEM_END);
        return this.doArrayNext();
    }

    private long doArrayNext() throws IOException {
        if (this.in.getCurrentToken() == JsonToken.END_ARRAY) {
            this.parser.advance(Symbol.ARRAY_END);
            this.in.nextToken();
            return 0L;
        }
        return 1L;
    }

    @Override
    public long skipArray() throws IOException {
        this.advance(Symbol.ARRAY_START);
        if (this.in.getCurrentToken() != JsonToken.START_ARRAY) {
            throw this.error("array-start");
        }
        this.in.skipChildren();
        this.in.nextToken();
        this.advance(Symbol.ARRAY_END);
        return 0L;
    }

    @Override
    public long readMapStart() throws IOException {
        this.advance(Symbol.MAP_START);
        if (this.in.getCurrentToken() == JsonToken.START_OBJECT) {
            this.in.nextToken();
            return this.doMapNext();
        }
        throw this.error("map-start");
    }

    @Override
    public long mapNext() throws IOException {
        this.advance(Symbol.ITEM_END);
        return this.doMapNext();
    }

    private long doMapNext() throws IOException {
        if (this.in.getCurrentToken() == JsonToken.END_OBJECT) {
            this.in.nextToken();
            this.advance(Symbol.MAP_END);
            return 0L;
        }
        return 1L;
    }

    @Override
    public long skipMap() throws IOException {
        this.advance(Symbol.MAP_START);
        if (this.in.getCurrentToken() != JsonToken.START_OBJECT) {
            throw this.error("map-start");
        }
        this.in.skipChildren();
        this.in.nextToken();
        this.advance(Symbol.MAP_END);
        return 0L;
    }

    @Override
    public int readIndex() throws IOException {
        String label;
        this.advance(Symbol.UNION);
        Symbol.Alternative a = (Symbol.Alternative)this.parser.popSymbol();
        if (this.in.getCurrentToken() == JsonToken.VALUE_NULL) {
            label = "null";
        } else if (this.in.getCurrentToken() == JsonToken.START_OBJECT && this.in.nextToken() == JsonToken.FIELD_NAME) {
            label = this.in.getText();
            this.in.nextToken();
            this.parser.pushSymbol(Symbol.UNION_END);
        } else {
            throw this.error("start-union");
        }
        int n = a.findLabel(label);
        if (n < 0) {
            throw new AvroTypeException("Unknown union branch " + label);
        }
        this.parser.pushSymbol(a.getSymbol(n));
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Symbol doAction(Symbol input, Symbol top) throws IOException {
        if (top instanceof Symbol.FieldAdjustAction) {
            List<JsonElement> node;
            Symbol.FieldAdjustAction fa = (Symbol.FieldAdjustAction)top;
            String name = fa.fname;
            if (this.currentReorderBuffer != null && (node = this.currentReorderBuffer.savedFields.get(name)) != null) {
                this.currentReorderBuffer.savedFields.remove(name);
                this.currentReorderBuffer.origParser = this.in;
                this.in = this.makeParser(node);
                return null;
            }
            if (this.in.getCurrentToken() != JsonToken.FIELD_NAME) return null;
            do {
                String fn = this.in.getText();
                this.in.nextToken();
                if (name.equals(fn)) {
                    return null;
                }
                if (this.currentReorderBuffer == null) {
                    this.currentReorderBuffer = new ReorderBuffer();
                }
                this.currentReorderBuffer.savedFields.put(fn, JsonDecoder.getVaueAsTree(this.in));
            } while (this.in.getCurrentToken() == JsonToken.FIELD_NAME);
            throw new AvroTypeException("Expected field name not found: " + fa.fname);
        }
        if (top == Symbol.FIELD_END) {
            if (this.currentReorderBuffer == null || this.currentReorderBuffer.origParser == null) return null;
            this.in = this.currentReorderBuffer.origParser;
            this.currentReorderBuffer.origParser = null;
            return null;
        } else if (top == Symbol.RECORD_START) {
            if (this.in.getCurrentToken() != JsonToken.START_OBJECT) throw this.error("record-start");
            this.in.nextToken();
            this.reorderBuffers.push(this.currentReorderBuffer);
            this.currentReorderBuffer = null;
            return null;
        } else {
            if (top != Symbol.RECORD_END && top != Symbol.UNION_END) throw new AvroTypeException("Unknown action symbol " + top);
            if (this.in.getCurrentToken() != JsonToken.END_OBJECT) throw this.error(top == Symbol.RECORD_END ? "record-end" : "union-end");
            this.in.nextToken();
            if (top != Symbol.RECORD_END) return null;
            if (this.currentReorderBuffer != null && !this.currentReorderBuffer.savedFields.isEmpty()) {
                throw this.error("Unknown fields: " + this.currentReorderBuffer.savedFields.keySet());
            }
            this.currentReorderBuffer = this.reorderBuffers.pop();
        }
        return null;
    }

    private static List<JsonElement> getVaueAsTree(JsonParser in) throws IOException {
        int level = 0;
        ArrayList<JsonElement> result = new ArrayList<JsonElement>();
        do {
            JsonToken t = in.getCurrentToken();
            switch (t) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++level;
                    result.add(new JsonElement(t));
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    --level;
                    result.add(new JsonElement(t));
                    break;
                }
                case FIELD_NAME: 
                case VALUE_STRING: 
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    result.add(new JsonElement(t, in.getText()));
                }
            }
            in.nextToken();
        } while (level != 0);
        result.add(new JsonElement(null));
        return result;
    }

    private JsonParser makeParser(final List<JsonElement> elements) throws IOException {
        return new JsonParser(){
            int pos = 0;

            @Override
            public ObjectCodec getCodec() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setCodec(ObjectCodec c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public JsonToken nextToken() throws IOException {
                ++this.pos;
                return ((JsonElement)elements.get((int)this.pos)).token;
            }

            @Override
            public JsonParser skipChildren() throws IOException {
                int level;
                JsonToken tkn = ((JsonElement)elements.get((int)this.pos)).token;
                int n = level = tkn == JsonToken.START_ARRAY || tkn == JsonToken.END_ARRAY ? 1 : 0;
                while (level > 0) {
                    switch (((JsonElement)elements.get((int)(++this.pos))).token) {
                        case START_OBJECT: 
                        case START_ARRAY: {
                            ++level;
                            break;
                        }
                        case END_OBJECT: 
                        case END_ARRAY: {
                            --level;
                        }
                    }
                }
                return this;
            }

            @Override
            public boolean isClosed() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getCurrentName() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public JsonStreamContext getParsingContext() {
                throw new UnsupportedOperationException();
            }

            @Override
            public JsonLocation getTokenLocation() {
                throw new UnsupportedOperationException();
            }

            @Override
            public JsonLocation getCurrentLocation() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getText() throws IOException {
                return ((JsonElement)elements.get((int)this.pos)).value;
            }

            @Override
            public char[] getTextCharacters() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getTextLength() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getTextOffset() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Number getNumberValue() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public JsonParser.NumberType getNumberType() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getIntValue() throws IOException {
                return Integer.parseInt(this.getText());
            }

            @Override
            public long getLongValue() throws IOException {
                return Long.parseLong(this.getText());
            }

            @Override
            public BigInteger getBigIntegerValue() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public float getFloatValue() throws IOException {
                return Float.parseFloat(this.getText());
            }

            @Override
            public double getDoubleValue() throws IOException {
                return Double.parseDouble(this.getText());
            }

            @Override
            public BigDecimal getDecimalValue() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public JsonToken getCurrentToken() {
                return ((JsonElement)elements.get((int)this.pos)).token;
            }
        };
    }

    private AvroTypeException error(String type) {
        return new AvroTypeException("Expected " + type + ". Got " + (Object)((Object)this.in.getCurrentToken()));
    }

    private static class JsonElement {
        public final JsonToken token;
        public final String value;

        public JsonElement(JsonToken t, String value) {
            this.token = t;
            this.value = value;
        }

        public JsonElement(JsonToken t) {
            this(t, null);
        }
    }

    private static class ReorderBuffer {
        public Map<String, List<JsonElement>> savedFields = new HashMap<String, List<JsonElement>>();
        public JsonParser origParser = null;

        private ReorderBuffer() {
        }
    }
}

