/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.typeutils;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.package$;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import scala.Tuple2;

@Internal
public final class Tuple2CaseClassSerializerSnapshot<T1, T2>
extends CompositeTypeSerializerSnapshot<Tuple2<T1, T2>, ScalaCaseClassSerializer<Tuple2<T1, T2>>> {
    private static final int VERSION = 2;
    private Class<Tuple2<T1, T2>> type;

    public Tuple2CaseClassSerializerSnapshot() {
        super(Tuple2CaseClassSerializerSnapshot.correspondingSerializerClass());
    }

    public Tuple2CaseClassSerializerSnapshot(ScalaCaseClassSerializer<Tuple2<T1, T2>> serializerInstance) {
        super(serializerInstance);
        this.type = (Class)Preconditions.checkNotNull((Object)serializerInstance.getTupleClass(), (String)"tuple class can not be NULL");
    }

    protected int getCurrentOuterSnapshotVersion() {
        return 2;
    }

    protected TypeSerializer<?>[] getNestedSerializers(ScalaCaseClassSerializer<Tuple2<T1, T2>> outerSerializer) {
        return outerSerializer.getFieldSerializers();
    }

    protected ScalaCaseClassSerializer<Tuple2<T1, T2>> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"tuple class can not be NULL");
        return package$.MODULE$.tuple2Serializer(this.type, nestedSerializers);
    }

    protected void writeOuterSnapshot(DataOutputView out) throws IOException {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"tuple class can not be NULL");
        out.writeUTF(this.type.getName());
    }

    protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.type = InstantiationUtil.resolveClassByName((DataInputView)in, (ClassLoader)userCodeClassLoader);
    }

    protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(ScalaCaseClassSerializer<Tuple2<T1, T2>> newSerializer) {
        return Objects.equals(this.type, newSerializer.getTupleClass()) ? CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS : CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE;
    }

    private static <T1, T2> Class<ScalaCaseClassSerializer<Tuple2<T1, T2>>> correspondingSerializerClass() {
        return package$.MODULE$.tuple2ClassForJava();
    }
}

