/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.benchmark.scheduling;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.scheduler.SchedulerOperations;
import org.apache.flink.runtime.scheduler.benchmark.JobConfiguration;
import org.apache.flink.runtime.scheduler.benchmark.scheduling.SchedulingBenchmarkBase;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.PipelinedRegionSchedulingStrategy;

public class SchedulingDownstreamTasksInBatchJobBenchmark
extends SchedulingBenchmarkBase {
    private ExecutionVertexID executionVertexID;
    private PipelinedRegionSchedulingStrategy schedulingStrategy;

    public void setup(JobConfiguration jobConfiguration) throws Exception {
        this.initSchedulingTopology(jobConfiguration);
        this.schedulingStrategy = new PipelinedRegionSchedulingStrategy((SchedulerOperations)this.schedulerOperations, this.schedulingTopology);
        for (IntermediateResult result : this.executionGraph.getAllIntermediateResults().values()) {
            Field f = result.getClass().getDeclaredField("numberOfRunningProducers");
            f.setAccessible(true);
            AtomicInteger numberOfRunningProducers = (AtomicInteger)f.get(result);
            numberOfRunningProducers.set(0);
        }
        this.executionVertexID = this.executionGraph.getJobVertex(((JobVertex)this.jobVertices.get(0)).getID()).getTaskVertices()[0].getID();
    }

    public void schedulingDownstreamTasks() {
        this.schedulingStrategy.onExecutionStateChange(this.executionVertexID, ExecutionState.FINISHED);
    }
}

