/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import akka.actor.ActorSystem;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.util.Preconditions;
import org.junit.rules.ExternalResource;

public class ActorSystemResource
extends ExternalResource {
    private final Configuration configuration;
    private ActorSystem actorSystem;

    private ActorSystemResource(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void before() throws Throwable {
        Preconditions.checkState((this.actorSystem == null ? 1 : 0) != 0, (Object)"ActorSystem must not be initialized when calling before.");
        this.actorSystem = AkkaUtils.createLocalActorSystem((Configuration)this.configuration);
    }

    protected void after() {
        Preconditions.checkState((this.actorSystem != null ? 1 : 0) != 0, (Object)"ActorSystem must be initialized when calling after.");
        AkkaUtils.terminateActorSystem((ActorSystem)this.actorSystem).join();
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public static ActorSystemResource defaultConfiguration() {
        return new ActorSystemResource(new Configuration());
    }

    public static ActorSystemResource withConfiguration(Configuration configuration) {
        return new ActorSystemResource(configuration);
    }
}

