/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.JobExecutionResultHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.JobExecutionResultResponseBody;
import org.apache.flink.runtime.rest.messages.queue.QueueStatus;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobExecutionResultHandlerTest
extends TestLogger {
    private static final JobID TEST_JOB_ID = new JobID();
    private JobExecutionResultHandler jobExecutionResultHandler;
    private HandlerRequest<EmptyRequestBody, JobMessageParameters> testRequest;

    @Before
    public void setUp() throws Exception {
        TestingRestfulGateway testingRestfulGateway = new TestingRestfulGateway.Builder().build();
        this.jobExecutionResultHandler = new JobExecutionResultHandler(() -> CompletableFuture.completedFuture(testingRestfulGateway), Time.seconds((long)10L), Collections.emptyMap());
        this.testRequest = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new JobMessageParameters(), Collections.singletonMap("jobid", TEST_JOB_ID.toString()), Collections.emptyMap());
    }

    @Test
    public void testResultInProgress() throws Exception {
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestJobStatusFunction(jobId -> CompletableFuture.completedFuture(JobStatus.RUNNING))).build();
        JobExecutionResultResponseBody responseBody = (JobExecutionResultResponseBody)this.jobExecutionResultHandler.handleRequest(this.testRequest, (RestfulGateway)testingRestfulGateway).get();
        Assert.assertThat((Object)responseBody.getStatus().getId(), (Matcher)Matchers.equalTo((Object)QueueStatus.Id.IN_PROGRESS));
    }

    @Test
    public void testCompletedResult() throws Exception {
        JobStatus jobStatus = JobStatus.FINISHED;
        ArchivedExecutionGraph executionGraph = new ArchivedExecutionGraphBuilder().setJobID(TEST_JOB_ID).setState(jobStatus).build();
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestJobStatusFunction(jobId -> {
            Assert.assertThat((Object)jobId, (Matcher)Matchers.equalTo((Object)TEST_JOB_ID));
            return CompletableFuture.completedFuture(jobStatus);
        })).setRequestJobResultFunction(jobId -> {
            Assert.assertThat((Object)jobId, (Matcher)Matchers.equalTo((Object)TEST_JOB_ID));
            return CompletableFuture.completedFuture(JobResult.createFrom((AccessExecutionGraph)executionGraph));
        })).build();
        JobExecutionResultResponseBody responseBody = (JobExecutionResultResponseBody)this.jobExecutionResultHandler.handleRequest(this.testRequest, (RestfulGateway)testingRestfulGateway).get();
        Assert.assertThat((Object)responseBody.getStatus().getId(), (Matcher)Matchers.equalTo((Object)QueueStatus.Id.COMPLETED));
        Assert.assertThat((Object)responseBody.getJobExecutionResult(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testPropagateFlinkJobNotFoundExceptionAsRestHandlerException() throws Exception {
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestJobStatusFunction(jobId -> FutureUtils.completedExceptionally((Throwable)new FlinkJobNotFoundException(jobId)))).build();
        try {
            this.jobExecutionResultHandler.handleRequest(this.testRequest, (RestfulGateway)testingRestfulGateway).get();
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (ExecutionException e) {
            Throwable cause = ExceptionUtils.stripCompletionException((Throwable)e.getCause());
            Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(RestHandlerException.class));
            Assert.assertThat((Object)((RestHandlerException)cause).getHttpResponseStatus(), (Matcher)Matchers.equalTo((Object)HttpResponseStatus.NOT_FOUND));
        }
    }
}

