/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;

public class MockOperatorCoordinatorContext
implements OperatorCoordinator.Context {
    private final OperatorID operatorID;
    private final ClassLoader userCodeClassLoader;
    private final int numSubtasks;
    private boolean jobFailed;
    private Throwable jobFailureReason;

    public MockOperatorCoordinatorContext(OperatorID operatorID, int numSubtasks) {
        this(operatorID, numSubtasks, MockOperatorCoordinatorContext.class.getClassLoader());
    }

    public MockOperatorCoordinatorContext(OperatorID operatorID, ClassLoader userCodeClassLoader) {
        this(operatorID, 1, userCodeClassLoader);
    }

    public MockOperatorCoordinatorContext(OperatorID operatorID, int numSubtasks, ClassLoader userCodeClassLoader) {
        this.operatorID = operatorID;
        this.numSubtasks = numSubtasks;
        this.jobFailed = false;
        this.jobFailureReason = null;
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public OperatorID getOperatorId() {
        return this.operatorID;
    }

    public void failJob(Throwable cause) {
        this.jobFailed = true;
        this.jobFailureReason = cause;
    }

    public int currentParallelism() {
        return this.numSubtasks;
    }

    public ClassLoader getUserCodeClassloader() {
        return this.userCodeClassLoader;
    }

    public boolean isJobFailed() {
        return this.jobFailed;
    }

    public Throwable getJobFailureReason() {
        return this.jobFailureReason;
    }
}

