/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.util.Preconditions;

public class TestingMiniClusterConfiguration
extends MiniClusterConfiguration {
    private final int numberDispatcherResourceManagerComponents;
    private final boolean localCommunication;

    public TestingMiniClusterConfiguration(Configuration configuration, int numTaskManagers, RpcServiceSharing rpcServiceSharing, @Nullable String commonBindAddress, int numberDispatcherResourceManagerComponents, boolean localCommunication) {
        super(configuration, numTaskManagers, rpcServiceSharing, commonBindAddress, MiniCluster.HaServices.CONFIGURED);
        this.numberDispatcherResourceManagerComponents = numberDispatcherResourceManagerComponents;
        this.localCommunication = localCommunication;
    }

    public int getNumberDispatcherResourceManagerComponents() {
        return this.numberDispatcherResourceManagerComponents;
    }

    public boolean isLocalCommunication() {
        return this.localCommunication;
    }

    public static class Builder {
        private Configuration configuration = new Configuration();
        private int numTaskManagers = 1;
        private int numSlotsPerTaskManager = 1;
        private RpcServiceSharing rpcServiceSharing = RpcServiceSharing.SHARED;
        private int numberDispatcherResourceManagerComponents = 1;
        private boolean localCommunication = false;
        @Nullable
        private String commonBindAddress = null;

        public Builder setConfiguration(Configuration configuration1) {
            this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration1);
            return this;
        }

        public Builder setNumTaskManagers(int numTaskManagers) {
            this.numTaskManagers = numTaskManagers;
            return this;
        }

        public Builder setNumSlotsPerTaskManager(int numSlotsPerTaskManager) {
            this.numSlotsPerTaskManager = numSlotsPerTaskManager;
            return this;
        }

        public Builder setRpcServiceSharing(RpcServiceSharing rpcServiceSharing) {
            this.rpcServiceSharing = (RpcServiceSharing)Preconditions.checkNotNull((Object)rpcServiceSharing);
            return this;
        }

        public Builder setCommonBindAddress(String commonBindAddress) {
            this.commonBindAddress = commonBindAddress;
            return this;
        }

        public Builder setNumberDispatcherResourceManagerComponents(int numberDispatcherResourceManagerComponents) {
            this.numberDispatcherResourceManagerComponents = numberDispatcherResourceManagerComponents;
            return this;
        }

        public Builder setLocalCommunication(boolean localCommunication) {
            this.localCommunication = localCommunication;
            return this;
        }

        public TestingMiniClusterConfiguration build() {
            Configuration modifiedConfiguration = new Configuration(this.configuration);
            modifiedConfiguration.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, this.numSlotsPerTaskManager);
            modifiedConfiguration.setString(RestOptions.ADDRESS, modifiedConfiguration.getString(RestOptions.ADDRESS, "localhost"));
            modifiedConfiguration.setInteger(RestOptions.PORT, modifiedConfiguration.getInteger(RestOptions.PORT, 0));
            return new TestingMiniClusterConfiguration(modifiedConfiguration, this.numTaskManagers, this.rpcServiceSharing, this.commonBindAddress, this.numberDispatcherResourceManagerComponents, this.localCommunication);
        }
    }
}

