/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.reader.RecordReader;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.types.IntValue;

public class TestingAbstractInvokables {
    private TestingAbstractInvokables() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " should not be instantiated.");
    }

    public static final class TestInvokableRecordCancel
    extends AbstractInvokable {
        private static CompletableFuture<Boolean> gotCanceledFuture = new CompletableFuture();

        public TestInvokableRecordCancel(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            Object o = new Object();
            RecordWriter recordWriter = new RecordWriterBuilder().build(this.getEnvironment().getWriter(0));
            for (int i = 0; i < 1024; ++i) {
                recordWriter.emit((IOReadableWritable)new IntValue(42));
            }
            gotCanceledFuture.get();
        }

        public Future<Void> cancel() {
            gotCanceledFuture.complete(true);
            return CompletableFuture.completedFuture(null);
        }

        public static void resetGotCanceledFuture() {
            gotCanceledFuture = new CompletableFuture();
        }

        public static CompletableFuture<Boolean> gotCanceled() {
            return gotCanceledFuture;
        }
    }

    public static class Receiver
    extends AbstractInvokable {
        public Receiver(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            RecordReader reader = new RecordReader((InputGate)this.getEnvironment().getInputGate(0), IntValue.class, this.getEnvironment().getTaskManagerInfo().getTmpDirectories());
            IntValue i1 = (IntValue)reader.next();
            IntValue i2 = (IntValue)reader.next();
            IntValue i3 = (IntValue)reader.next();
            if (i1.getValue() != 42 || i2.getValue() != 1337 || i3 != null) {
                throw new Exception("Wrong data received.");
            }
        }
    }

    public static class Sender
    extends AbstractInvokable {
        public Sender(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            try (RecordWriter writer = new RecordWriterBuilder().build(this.getEnvironment().getWriter(0));){
                writer.emit((IOReadableWritable)new IntValue(42));
                writer.emit((IOReadableWritable)new IntValue(1337));
                writer.flushAll();
            }
        }
    }
}

