/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.serialization.types.SerializationTestType;

public class LargeObjectType
implements SerializationTestType {
    private static final int MIN_LEN = 12000000;
    private static final int MAX_LEN = 40000000;
    private int len;

    public LargeObjectType() {
        this.len = 0;
    }

    public LargeObjectType(int len) {
        this.len = len;
    }

    public LargeObjectType getRandom(Random rnd) {
        int len = rnd.nextInt(28000000) + 12000000;
        return new LargeObjectType(len);
    }

    public int length() {
        return this.len + 4;
    }

    public void write(DataOutputView out) throws IOException {
        int i;
        out.writeInt(this.len);
        for (i = 0; i < this.len / 8; ++i) {
            out.writeLong((long)i);
        }
        for (i = 0; i < this.len % 8; ++i) {
            out.write(i);
        }
    }

    public void read(DataInputView in) throws IOException {
        int i;
        int len;
        this.len = len = in.readInt();
        for (i = 0; i < len / 8; ++i) {
            if (in.readLong() == (long)i) continue;
            throw new IOException("corrupt serialization");
        }
        for (i = 0; i < len % 8; ++i) {
            if (in.readByte() == i) continue;
            throw new IOException("corrupt serialization");
        }
    }

    public int hashCode() {
        return this.len;
    }

    public boolean equals(Object obj) {
        return obj instanceof LargeObjectType && ((LargeObjectType)obj).len == this.len;
    }

    public String toString() {
        return "Large Object " + this.len;
    }
}

