/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;

public class TestInputChannel
extends InputChannel {
    private final Queue<BufferAndAvailabilityProvider> buffers = new ConcurrentLinkedQueue<BufferAndAvailabilityProvider>();
    private final Collection<Buffer> allReturnedBuffers = new ArrayList<Buffer>();
    private final boolean reuseLastReturnBuffer;
    private final boolean notifyChannelNonEmpty;
    private BufferAndAvailabilityProvider lastProvider = null;
    private boolean isReleased = false;
    private boolean isBlocked;
    private int sequenceNumber;

    public TestInputChannel(SingleInputGate inputGate, int channelIndex) {
        this(inputGate, channelIndex, true, false);
    }

    public TestInputChannel(SingleInputGate inputGate, int channelIndex, boolean reuseLastReturnBuffer, boolean notifyChannelNonEmpty) {
        super(inputGate, channelIndex, new ResultPartitionID(), 0, 0, (Counter)new SimpleCounter(), (Counter)new SimpleCounter());
        this.reuseLastReturnBuffer = reuseLastReturnBuffer;
        this.notifyChannelNonEmpty = notifyChannelNonEmpty;
    }

    public TestInputChannel read(Buffer buffer) throws IOException, InterruptedException {
        return this.read(buffer, Buffer.DataType.DATA_BUFFER);
    }

    public TestInputChannel read(Buffer buffer, @Nullable Buffer.DataType nextType) throws IOException, InterruptedException {
        this.addBufferAndAvailability(new InputChannel.BufferAndAvailability(buffer, nextType, 0, this.sequenceNumber++));
        if (this.notifyChannelNonEmpty) {
            this.notifyChannelNonEmpty();
        }
        return this;
    }

    TestInputChannel readBuffer() throws IOException, InterruptedException {
        return this.readBuffer(Buffer.DataType.DATA_BUFFER);
    }

    TestInputChannel readBuffer(Buffer.DataType nextType) throws IOException, InterruptedException {
        return this.read(TestBufferFactory.createBuffer(1), nextType);
    }

    TestInputChannel readEndOfPartitionEvent() {
        this.addBufferAndAvailability(() -> {
            this.setReleased();
            return Optional.of(new InputChannel.BufferAndAvailability(EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE, (boolean)false), Buffer.DataType.NONE, 0, this.sequenceNumber++));
        });
        return this;
    }

    void addBufferAndAvailability(InputChannel.BufferAndAvailability bufferAndAvailability) {
        this.buffers.add(() -> Optional.of(bufferAndAvailability));
    }

    void addBufferAndAvailability(BufferAndAvailabilityProvider bufferAndAvailability) {
        this.buffers.add(bufferAndAvailability);
    }

    static TestInputChannel[] createInputChannels(SingleInputGate inputGate, int numberOfInputChannels) {
        Preconditions.checkNotNull((Object)inputGate);
        Preconditions.checkArgument((numberOfInputChannels > 0 ? 1 : 0) != 0);
        InputChannel[] mocks = new TestInputChannel[numberOfInputChannels];
        for (int i = 0; i < numberOfInputChannels; ++i) {
            mocks[i] = new TestInputChannel(inputGate, i);
        }
        inputGate.setInputChannels(mocks);
        return mocks;
    }

    void requestSubpartition(int subpartitionIndex) throws IOException, InterruptedException {
    }

    Optional<InputChannel.BufferAndAvailability> getNextBuffer() throws IOException, InterruptedException {
        Preconditions.checkState((!this.isReleased ? 1 : 0) != 0);
        BufferAndAvailabilityProvider provider = this.buffers.poll();
        if (provider != null) {
            if (this.reuseLastReturnBuffer) {
                this.lastProvider = provider;
            }
            Optional<InputChannel.BufferAndAvailability> baa = provider.getBufferAvailability();
            baa.ifPresent(v -> this.allReturnedBuffers.add(v.buffer()));
            return baa;
        }
        if (this.lastProvider != null) {
            return this.lastProvider.getBufferAvailability();
        }
        return Optional.empty();
    }

    void sendTaskEvent(TaskEvent event) throws IOException {
    }

    boolean isReleased() {
        return this.isReleased;
    }

    void setReleased() {
        this.isReleased = true;
    }

    void releaseAllResources() throws IOException {
        this.isReleased = true;
    }

    public void resumeConsumption() {
        this.isBlocked = false;
    }

    protected void notifyChannelNonEmpty() {
        this.inputGate.notifyChannelNonEmpty((InputChannel)this);
    }

    public void assertReturnedEventsAreRecycled() {
        this.assertReturnedBuffersAreRecycled(false, true);
    }

    private void assertReturnedBuffersAreRecycled(boolean assertBuffers, boolean assertEvents) {
        for (Buffer b : this.allReturnedBuffers) {
            if (b.isBuffer() && assertBuffers && !b.isRecycled()) {
                Assert.fail((String)("Data Buffer " + b + " not recycled"));
            }
            if (b.isBuffer() || !assertEvents || b.isRecycled()) continue;
            Assert.fail((String)("Event Buffer " + b + " not recycled"));
        }
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    static interface BufferAndAvailabilityProvider {
        public Optional<InputChannel.BufferAndAvailability> getBufferAvailability() throws IOException, InterruptedException;
    }
}

