/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounterTestBase;
import org.apache.flink.runtime.checkpoint.DefaultLastStateConnectionStateListener;
import org.apache.flink.runtime.checkpoint.LastStateConnectionStateListener;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointIDCounter;
import org.apache.flink.runtime.zookeeper.ZooKeeperTestEnvironment;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperCheckpointIDCounterITCase
extends CheckpointIDCounterTestBase {
    private static final ZooKeeperTestEnvironment ZooKeeper = new ZooKeeperTestEnvironment(1);

    @AfterClass
    public static void tearDown() throws Exception {
        ZooKeeper.shutdown();
    }

    @Before
    public void cleanUp() throws Exception {
        ZooKeeper.deleteAll();
    }

    @Test
    public void testShutdownRemovesState() throws Exception {
        CheckpointIDCounter counter = this.createCheckpointIdCounter();
        counter.start();
        CuratorFramework client = ZooKeeper.getClient();
        Assert.assertNotNull((Object)client.checkExists().forPath("/checkpoint-id-counter"));
        counter.shutdown(JobStatus.FINISHED);
        Assert.assertNull((Object)client.checkExists().forPath("/checkpoint-id-counter"));
    }

    @Test
    public void testSuspendKeepsState() throws Exception {
        CheckpointIDCounter counter = this.createCheckpointIdCounter();
        counter.start();
        CuratorFramework client = ZooKeeper.getClient();
        Assert.assertNotNull((Object)client.checkExists().forPath("/checkpoint-id-counter"));
        counter.shutdown(JobStatus.SUSPENDED);
        Assert.assertNotNull((Object)client.checkExists().forPath("/checkpoint-id-counter"));
    }

    @Override
    protected CheckpointIDCounter createCheckpointIdCounter() throws Exception {
        return new ZooKeeperCheckpointIDCounter(ZooKeeper.getClient(), "/checkpoint-id-counter", (LastStateConnectionStateListener)new DefaultLastStateConnectionStateListener());
    }
}

