/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.net.InetAddress;
import java.util.UUID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalException;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.net.ConnectionUtils;
import org.apache.flink.runtime.util.LeaderConnectionInfo;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.impl.Promise;

public class LeaderRetrievalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderRetrievalUtils.class);

    public static LeaderConnectionInfo retrieveLeaderConnectionInfo(LeaderRetrievalService leaderRetrievalService, Time timeout) throws LeaderRetrievalException {
        return LeaderRetrievalUtils.retrieveLeaderConnectionInfo(leaderRetrievalService, FutureUtils.toFiniteDuration(timeout));
    }

    public static LeaderConnectionInfo retrieveLeaderConnectionInfo(LeaderRetrievalService leaderRetrievalService, FiniteDuration timeout) throws LeaderRetrievalException {
        LeaderConnectionInfoListener listener = new LeaderConnectionInfoListener();
        try {
            leaderRetrievalService.start(listener);
            Future<LeaderConnectionInfo> connectionInfoFuture = listener.getLeaderConnectionInfoFuture();
            LeaderConnectionInfo leaderConnectionInfo = (LeaderConnectionInfo)Await.result(connectionInfoFuture, (Duration)timeout);
            return leaderConnectionInfo;
        }
        catch (Exception e) {
            throw new LeaderRetrievalException("Could not retrieve the leader address and leader session ID.", e);
        }
        finally {
            try {
                leaderRetrievalService.stop();
            }
            catch (Exception fe) {
                LOG.warn("Could not stop the leader retrieval service.", (Throwable)fe);
            }
        }
    }

    public static InetAddress findConnectingAddress(LeaderRetrievalService leaderRetrievalService, Time timeout) throws LeaderRetrievalException {
        return LeaderRetrievalUtils.findConnectingAddress(leaderRetrievalService, new FiniteDuration(timeout.getSize(), timeout.getUnit()));
    }

    public static InetAddress findConnectingAddress(LeaderRetrievalService leaderRetrievalService, FiniteDuration timeout) throws LeaderRetrievalException {
        ConnectionUtils.LeaderConnectingAddressListener listener = new ConnectionUtils.LeaderConnectingAddressListener();
        try {
            leaderRetrievalService.start(listener);
            LOG.info("Trying to select the network interface and address to use by connecting to the leading JobManager.");
            LOG.info("TaskManager will try to connect for " + timeout + " before falling back to heuristics");
            InetAddress inetAddress = listener.findConnectingAddress(timeout);
            return inetAddress;
        }
        catch (Exception e) {
            throw new LeaderRetrievalException("Could not find the connecting address by connecting to the current leader.", e);
        }
        finally {
            try {
                leaderRetrievalService.stop();
            }
            catch (Exception fe) {
                LOG.warn("Could not stop the leader retrieval service.", (Throwable)fe);
            }
        }
    }

    private LeaderRetrievalUtils() {
        throw new RuntimeException();
    }

    public static class LeaderConnectionInfoListener
    implements LeaderRetrievalListener {
        private final Promise<LeaderConnectionInfo> connectionInfo = new Promise.DefaultPromise();

        public Future<LeaderConnectionInfo> getLeaderConnectionInfoFuture() {
            return this.connectionInfo.future();
        }

        @Override
        public void notifyLeaderAddress(String leaderAddress, UUID leaderSessionID) {
            if (leaderAddress != null && !leaderAddress.equals("") && !this.connectionInfo.isCompleted()) {
                try {
                    LeaderConnectionInfo leaderConnectionInfo = new LeaderConnectionInfo(leaderAddress, leaderSessionID);
                    this.connectionInfo.success((Object)leaderConnectionInfo);
                }
                catch (FlinkException e) {
                    this.connectionInfo.failure((Throwable)e);
                }
            }
        }

        @Override
        public void handleError(Exception exception) {
            if (!this.connectionInfo.isCompleted()) {
                this.connectionInfo.failure((Throwable)exception);
            }
        }
    }
}

