/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.util.MathUtils;

public class ConfigurationParserUtils {
    public static long getManagedMemorySize(Configuration configuration) {
        long managedMemorySize;
        String managedMemorySizeDefaultVal = (String)TaskManagerOptions.MANAGED_MEMORY_SIZE.defaultValue();
        if (!configuration.getString(TaskManagerOptions.MANAGED_MEMORY_SIZE).equals(managedMemorySizeDefaultVal)) {
            try {
                managedMemorySize = MemorySize.parse((String)configuration.getString(TaskManagerOptions.MANAGED_MEMORY_SIZE), (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES).getMebiBytes();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalConfigurationException("Could not read " + TaskManagerOptions.MANAGED_MEMORY_SIZE.key(), (Throwable)e);
            }
        } else {
            managedMemorySize = Long.valueOf(managedMemorySizeDefaultVal);
        }
        ConfigurationParserUtils.checkConfigParameter(configuration.getString(TaskManagerOptions.MANAGED_MEMORY_SIZE).equals(TaskManagerOptions.MANAGED_MEMORY_SIZE.defaultValue()) || managedMemorySize > 0L, managedMemorySize, TaskManagerOptions.MANAGED_MEMORY_SIZE.key(), "MemoryManager needs at least one MB of memory. If you leave this config parameter empty, the system automatically pick a fraction of the available memory.");
        return managedMemorySize;
    }

    public static float getManagedMemoryFraction(Configuration configuration) {
        float managedMemoryFraction = configuration.getFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION);
        ConfigurationParserUtils.checkConfigParameter(managedMemoryFraction > 0.0f && managedMemoryFraction < 1.0f, Float.valueOf(managedMemoryFraction), TaskManagerOptions.MANAGED_MEMORY_FRACTION.key(), "MemoryManager fraction of the free memory must be between 0.0 and 1.0");
        return managedMemoryFraction;
    }

    public static MemoryType getMemoryType(Configuration configuration) {
        MemoryType memType = configuration.getBoolean(TaskManagerOptions.MEMORY_OFF_HEAP) ? MemoryType.OFF_HEAP : MemoryType.HEAP;
        return memType;
    }

    public static int getSlot(Configuration configuration) {
        int slots = configuration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS, 1);
        if (slots == -1) {
            slots = 1;
        }
        ConfigurationParserUtils.checkConfigParameter(slots >= 1, slots, TaskManagerOptions.NUM_TASK_SLOTS.key(), "Number of task slots must be at least one.");
        return slots;
    }

    public static void checkConfigParameter(boolean condition, Object parameter, String name, String errorMessage) throws IllegalConfigurationException {
        if (!condition) {
            throw new IllegalConfigurationException("Invalid configuration value for " + name + " : " + parameter + " - " + errorMessage);
        }
    }

    public static int getPageSize(Configuration configuration) {
        int pageSize = MathUtils.checkedDownCast((long)MemorySize.parse((String)configuration.getString(TaskManagerOptions.MEMORY_SEGMENT_SIZE)).getBytes());
        ConfigurationParserUtils.checkConfigParameter(pageSize >= 4096, pageSize, TaskManagerOptions.MEMORY_SEGMENT_SIZE.key(), "Minimum memory segment size is 4096");
        ConfigurationParserUtils.checkConfigParameter(MathUtils.isPowerOf2((long)pageSize), pageSize, TaskManagerOptions.MEMORY_SEGMENT_SIZE.key(), "Memory segment size must be a power of 2.");
        return pageSize;
    }
}

