/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.state.MapState;

class UserFacingMapState<K, V>
implements MapState<K, V> {
    private final MapState<K, V> originalState;
    private final Map<K, V> emptyState = Collections.emptyMap();

    UserFacingMapState(MapState<K, V> originalState) {
        this.originalState = originalState;
    }

    public V get(K key) throws Exception {
        return (V)this.originalState.get(key);
    }

    public void put(K key, V value) throws Exception {
        this.originalState.put(key, value);
    }

    public void putAll(Map<K, V> value) throws Exception {
        this.originalState.putAll(value);
    }

    public void clear() {
        this.originalState.clear();
    }

    public void remove(K key) throws Exception {
        this.originalState.remove(key);
    }

    public boolean contains(K key) throws Exception {
        return this.originalState.contains(key);
    }

    public Iterable<Map.Entry<K, V>> entries() throws Exception {
        Set<Map.Entry<K, V>> original = this.originalState.entries();
        return original != null ? original : this.emptyState.entrySet();
    }

    public Iterable<K> keys() throws Exception {
        Set<K> original = this.originalState.keys();
        return original != null ? original : this.emptyState.keySet();
    }

    public Iterable<V> values() throws Exception {
        Collection<V> original = this.originalState.values();
        return original != null ? original : this.emptyState.values();
    }

    public Iterator<Map.Entry<K, V>> iterator() throws Exception {
        Iterator<Map.Entry<K, V>> original = this.originalState.iterator();
        return original != null ? original : this.emptyState.entrySet().iterator();
    }
}

