/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.LongPredicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.LocalRecoveryDirectoryProvider;
import org.apache.flink.runtime.state.OwnedTaskLocalStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLocalStateStoreImpl
implements OwnedTaskLocalStateStore {
    private static final Logger LOG = LoggerFactory.getLogger(TaskLocalStateStoreImpl.class);
    @VisibleForTesting
    static final TaskStateSnapshot NULL_DUMMY = new TaskStateSnapshot(0);
    @Nonnull
    private final JobID jobID;
    @Nonnull
    private final AllocationID allocationID;
    @Nonnull
    private final JobVertexID jobVertexID;
    @Nonnegative
    private final int subtaskIndex;
    @Nonnull
    private final LocalRecoveryConfig localRecoveryConfig;
    @Nonnull
    private final Executor discardExecutor;
    @Nonnull
    private final Object lock;
    @GuardedBy(value="lock")
    private boolean disposed;
    @Nonnull
    @GuardedBy(value="lock")
    private final SortedMap<Long, TaskStateSnapshot> storedTaskStateByCheckpointID;

    public TaskLocalStateStoreImpl(@Nonnull JobID jobID, @Nonnull AllocationID allocationID, @Nonnull JobVertexID jobVertexID, @Nonnegative int subtaskIndex, @Nonnull LocalRecoveryConfig localRecoveryConfig, @Nonnull Executor discardExecutor) {
        this(jobID, allocationID, jobVertexID, subtaskIndex, localRecoveryConfig, discardExecutor, new TreeMap<Long, TaskStateSnapshot>(), new Object());
    }

    @VisibleForTesting
    TaskLocalStateStoreImpl(@Nonnull JobID jobID, @Nonnull AllocationID allocationID, @Nonnull JobVertexID jobVertexID, @Nonnegative int subtaskIndex, @Nonnull LocalRecoveryConfig localRecoveryConfig, @Nonnull Executor discardExecutor, @Nonnull SortedMap<Long, TaskStateSnapshot> storedTaskStateByCheckpointID, @Nonnull Object lock) {
        this.jobID = jobID;
        this.allocationID = allocationID;
        this.jobVertexID = jobVertexID;
        this.subtaskIndex = subtaskIndex;
        this.discardExecutor = discardExecutor;
        this.localRecoveryConfig = localRecoveryConfig;
        this.storedTaskStateByCheckpointID = storedTaskStateByCheckpointID;
        this.lock = lock;
        this.disposed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeLocalState(@Nonnegative long checkpointId, @Nullable TaskStateSnapshot localState) {
        if (localState == null) {
            localState = NULL_DUMMY;
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("Stored local state for checkpoint {} in subtask ({} - {} - {}) : {}.", new Object[]{checkpointId, this.jobID, this.jobVertexID, this.subtaskIndex, localState});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Stored local state for checkpoint {} in subtask ({} - {} - {})", new Object[]{checkpointId, this.jobID, this.jobVertexID, this.subtaskIndex});
        }
        AbstractMap.SimpleEntry<Long, TaskStateSnapshot> toDiscard = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed) {
                toDiscard = new AbstractMap.SimpleEntry<Long, TaskStateSnapshot>(checkpointId, localState);
            } else {
                TaskStateSnapshot previous = this.storedTaskStateByCheckpointID.put(checkpointId, localState);
                if (previous != null) {
                    toDiscard = new AbstractMap.SimpleEntry<Long, TaskStateSnapshot>(checkpointId, previous);
                }
            }
        }
        if (toDiscard != null) {
            this.asyncDiscardLocalStateForCollection(Collections.singletonList(toDiscard));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TaskStateSnapshot retrieveLocalState(long checkpointID) {
        TaskStateSnapshot snapshot;
        Object object = this.lock;
        synchronized (object) {
            snapshot = (TaskStateSnapshot)this.storedTaskStateByCheckpointID.get(checkpointID);
        }
        if (snapshot != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found registered local state for checkpoint {} in subtask ({} - {} - {}) : {}", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex, snapshot});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Found registered local state for checkpoint {} in subtask ({} - {} - {})", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex});
            }
        } else {
            LOG.debug("Did not find registered local state for checkpoint {} in subtask ({} - {} - {})", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex});
        }
        return snapshot != NULL_DUMMY ? snapshot : null;
    }

    @Override
    @Nonnull
    public LocalRecoveryConfig getLocalRecoveryConfig() {
        return this.localRecoveryConfig;
    }

    @Override
    public void confirmCheckpoint(long confirmedCheckpointId) {
        LOG.debug("Received confirmation for checkpoint {} in subtask ({} - {} - {}). Starting to prune history.", new Object[]{confirmedCheckpointId, this.jobID, this.jobVertexID, this.subtaskIndex});
        this.pruneCheckpoints(snapshotCheckpointId -> snapshotCheckpointId < confirmedCheckpointId, true);
    }

    @Override
    public void pruneMatchingCheckpoints(@Nonnull LongPredicate matcher) {
        this.pruneCheckpoints(matcher, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> dispose() {
        ArrayList<Map.Entry<Long, TaskStateSnapshot>> statesCopy;
        Object object = this.lock;
        synchronized (object) {
            this.disposed = true;
            statesCopy = new ArrayList<Map.Entry<Long, TaskStateSnapshot>>(this.storedTaskStateByCheckpointID.entrySet());
            this.storedTaskStateByCheckpointID.clear();
        }
        return CompletableFuture.runAsync(() -> {
            this.syncDiscardLocalStateForCollection(statesCopy);
            LocalRecoveryDirectoryProvider directoryProvider = this.localRecoveryConfig.getLocalStateDirectoryProvider();
            for (int i = 0; i < directoryProvider.allocationBaseDirsCount(); ++i) {
                File subtaskBaseDirectory = directoryProvider.selectSubtaskBaseDirectory(i);
                try {
                    this.deleteDirectory(subtaskBaseDirectory);
                    continue;
                }
                catch (IOException e) {
                    LOG.warn("Exception when deleting local recovery subtask base directory {} in subtask ({} - {} - {})", new Object[]{subtaskBaseDirectory, this.jobID, this.jobVertexID, this.subtaskIndex, e});
                }
            }
        }, this.discardExecutor);
    }

    private void asyncDiscardLocalStateForCollection(Collection<Map.Entry<Long, TaskStateSnapshot>> toDiscard) {
        if (!toDiscard.isEmpty()) {
            this.discardExecutor.execute(() -> this.syncDiscardLocalStateForCollection(toDiscard));
        }
    }

    private void syncDiscardLocalStateForCollection(Collection<Map.Entry<Long, TaskStateSnapshot>> toDiscard) {
        for (Map.Entry<Long, TaskStateSnapshot> entry : toDiscard) {
            this.discardLocalStateForCheckpoint(entry.getKey(), entry.getValue());
        }
    }

    private void discardLocalStateForCheckpoint(long checkpointID, TaskStateSnapshot o) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Discarding local task state snapshot of checkpoint {} for subtask ({} - {} - {}).", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex});
        } else {
            LOG.debug("Discarding local task state snapshot {} of checkpoint {} for subtask ({} - {} - {}).", new Object[]{o, checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex});
        }
        try {
            o.discardState();
        }
        catch (Exception discardEx) {
            LOG.warn("Exception while discarding local task state snapshot of checkpoint {} in subtask ({} - {} - {}).", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex, discardEx});
        }
        LocalRecoveryDirectoryProvider directoryProvider = this.localRecoveryConfig.getLocalStateDirectoryProvider();
        File checkpointDir = directoryProvider.subtaskSpecificCheckpointDirectory(checkpointID);
        LOG.debug("Deleting local state directory {} of checkpoint {} for subtask ({} - {} - {}).", new Object[]{checkpointDir, checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex});
        try {
            this.deleteDirectory(checkpointDir);
        }
        catch (IOException ex) {
            LOG.warn("Exception while deleting local state directory of checkpoint {} in subtask ({} - {} - {}).", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex, ex});
        }
    }

    private void deleteDirectory(File directory) throws IOException {
        Path path = new Path(directory.toURI());
        FileSystem fileSystem = path.getFileSystem();
        if (fileSystem.exists(path)) {
            fileSystem.delete(path, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneCheckpoints(LongPredicate pruningChecker, boolean breakOnceCheckerFalse) {
        ArrayList<Map.Entry<Long, TaskStateSnapshot>> toRemove = new ArrayList<Map.Entry<Long, TaskStateSnapshot>>();
        Object object = this.lock;
        synchronized (object) {
            Iterator<Map.Entry<Long, TaskStateSnapshot>> entryIterator = this.storedTaskStateByCheckpointID.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry<Long, TaskStateSnapshot> snapshotEntry = entryIterator.next();
                long entryCheckpointId = snapshotEntry.getKey();
                if (pruningChecker.test(entryCheckpointId)) {
                    toRemove.add(snapshotEntry);
                    entryIterator.remove();
                    continue;
                }
                if (!breakOnceCheckerFalse) continue;
                break;
            }
        }
        this.asyncDiscardLocalStateForCollection(toRemove);
    }

    public String toString() {
        return "TaskLocalStateStore{jobID=" + this.jobID + ", jobVertexID=" + (Object)((Object)this.jobVertexID) + ", allocationID=" + this.allocationID.toHexString() + ", subtaskIndex=" + this.subtaskIndex + ", localRecoveryConfig=" + this.localRecoveryConfig + ", storedCheckpointIDs=" + this.storedTaskStateByCheckpointID.keySet() + '}';
    }
}

