/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.DirectoryStateHandle;

public abstract class SnapshotDirectory {
    @Nonnull
    protected final Path directory;
    @Nonnull
    protected final FileSystem fileSystem;
    @Nonnull
    protected AtomicReference<State> state;

    private SnapshotDirectory(@Nonnull Path directory, @Nonnull FileSystem fileSystem) {
        this.directory = directory;
        this.fileSystem = fileSystem;
        this.state = new AtomicReference<State>(State.ONGOING);
    }

    private SnapshotDirectory(@Nonnull Path directory) throws IOException {
        this(directory, directory.getFileSystem());
    }

    @Nonnull
    public Path getDirectory() {
        return this.directory;
    }

    public boolean mkdirs() throws IOException {
        return this.fileSystem.mkdirs(this.directory);
    }

    @Nonnull
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public boolean exists() throws IOException {
        return this.fileSystem.exists(this.directory);
    }

    public FileStatus[] listStatus() throws IOException {
        return this.fileSystem.listStatus(this.directory);
    }

    public boolean cleanup() throws IOException {
        return !this.state.compareAndSet(State.ONGOING, State.DELETED) || this.fileSystem.delete(this.directory, true);
    }

    public boolean isSnapshotCompleted() {
        return State.COMPLETED == this.state.get();
    }

    @Nullable
    public abstract DirectoryStateHandle completeSnapshotAndGetHandle() throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotDirectory that = (SnapshotDirectory)o;
        return this.directory.equals((Object)that.directory);
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    public String toString() {
        return "SnapshotDirectory{directory=" + this.directory + ", state=" + this.state + '}';
    }

    public static SnapshotDirectory temporary(@Nonnull File directory) throws IOException {
        return new TemporarySnapshotDirectory(directory);
    }

    public static SnapshotDirectory permanent(@Nonnull Path directory) throws IOException {
        return new PermanentSnapshotDirectory(directory);
    }

    private static class PermanentSnapshotDirectory
    extends SnapshotDirectory {
        PermanentSnapshotDirectory(@Nonnull Path directory) throws IOException {
            super(directory);
        }

        @Override
        public DirectoryStateHandle completeSnapshotAndGetHandle() throws IOException {
            if (State.COMPLETED == this.state.get() || this.state.compareAndSet(State.ONGOING, State.COMPLETED)) {
                return new DirectoryStateHandle(this.directory);
            }
            throw new IOException("Expected state " + (Object)((Object)State.ONGOING) + " but found state " + this.state.get());
        }
    }

    private static class TemporarySnapshotDirectory
    extends SnapshotDirectory {
        TemporarySnapshotDirectory(@Nonnull File directory) throws IOException {
            super(new Path(directory.toURI()), FileSystem.getLocalFileSystem());
        }

        @Override
        public DirectoryStateHandle completeSnapshotAndGetHandle() {
            return null;
        }
    }

    static enum State {
        ONGOING,
        COMPLETED,
        DELETED;

    }
}

