/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.adapter.DefaultSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultSchedulingResultPartition;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.Preconditions;

public class ExecutionGraphToSchedulingTopologyAdapter
implements SchedulingTopology {
    private final Map<ExecutionVertexID, DefaultSchedulingExecutionVertex> executionVerticesById;
    private final List<SchedulingExecutionVertex> executionVerticesList;
    private final Map<IntermediateResultPartitionID, ? extends SchedulingResultPartition> resultPartitionsById;

    public ExecutionGraphToSchedulingTopologyAdapter(ExecutionGraph graph) {
        Preconditions.checkNotNull((Object)graph, (String)"execution graph can not be null");
        this.executionVerticesById = new HashMap<ExecutionVertexID, DefaultSchedulingExecutionVertex>();
        this.executionVerticesList = new ArrayList<SchedulingExecutionVertex>(graph.getTotalNumberOfVertices());
        HashMap<IntermediateResultPartitionID, ? extends SchedulingResultPartition> tmpResultPartitionsById = new HashMap<IntermediateResultPartitionID, SchedulingResultPartition>();
        HashMap<ExecutionVertex, DefaultSchedulingExecutionVertex> executionVertexMap = new HashMap<ExecutionVertex, DefaultSchedulingExecutionVertex>();
        for (ExecutionVertex vertex : graph.getAllExecutionVertices()) {
            List<DefaultSchedulingResultPartition> producedPartitions = ExecutionGraphToSchedulingTopologyAdapter.generateProducedSchedulingResultPartition(vertex.getProducedPartitions());
            producedPartitions.forEach(partition -> tmpResultPartitionsById.put(partition.getId(), (SchedulingResultPartition)partition));
            DefaultSchedulingExecutionVertex schedulingVertex = ExecutionGraphToSchedulingTopologyAdapter.generateSchedulingExecutionVertex(vertex, producedPartitions);
            this.executionVerticesById.put(schedulingVertex.getId(), schedulingVertex);
            this.executionVerticesList.add(schedulingVertex);
            executionVertexMap.put(vertex, schedulingVertex);
        }
        this.resultPartitionsById = tmpResultPartitionsById;
        ExecutionGraphToSchedulingTopologyAdapter.connectVerticesToConsumedPartitions(executionVertexMap, tmpResultPartitionsById);
    }

    @Override
    public Iterable<SchedulingExecutionVertex> getVertices() {
        return this.executionVerticesList;
    }

    @Override
    public Optional<SchedulingExecutionVertex> getVertex(ExecutionVertexID executionVertexId) {
        return Optional.ofNullable(this.executionVerticesById.get(executionVertexId));
    }

    @Override
    public Optional<SchedulingResultPartition> getResultPartition(IntermediateResultPartitionID intermediateResultPartitionId) {
        return Optional.ofNullable(this.resultPartitionsById.get((Object)intermediateResultPartitionId));
    }

    private static List<DefaultSchedulingResultPartition> generateProducedSchedulingResultPartition(Map<IntermediateResultPartitionID, IntermediateResultPartition> producedIntermediatePartitions) {
        ArrayList<DefaultSchedulingResultPartition> producedSchedulingPartitions = new ArrayList<DefaultSchedulingResultPartition>(producedIntermediatePartitions.size());
        producedIntermediatePartitions.values().forEach(irp -> producedSchedulingPartitions.add(new DefaultSchedulingResultPartition(irp.getPartitionId(), irp.getIntermediateResult().getId(), irp.getResultType())));
        return producedSchedulingPartitions;
    }

    private static DefaultSchedulingExecutionVertex generateSchedulingExecutionVertex(ExecutionVertex vertex, List<DefaultSchedulingResultPartition> producedPartitions) {
        DefaultSchedulingExecutionVertex schedulingVertex = new DefaultSchedulingExecutionVertex(new ExecutionVertexID(vertex.getJobvertexId(), vertex.getParallelSubtaskIndex()), producedPartitions, new ExecutionStateSupplier(vertex), vertex.getInputDependencyConstraint());
        producedPartitions.forEach(partition -> partition.setProducer(schedulingVertex));
        return schedulingVertex;
    }

    private static void connectVerticesToConsumedPartitions(Map<ExecutionVertex, DefaultSchedulingExecutionVertex> executionVertexMap, Map<IntermediateResultPartitionID, DefaultSchedulingResultPartition> resultPartitions) {
        for (Map.Entry<ExecutionVertex, DefaultSchedulingExecutionVertex> mapEntry : executionVertexMap.entrySet()) {
            DefaultSchedulingExecutionVertex schedulingVertex = mapEntry.getValue();
            ExecutionVertex executionVertex = mapEntry.getKey();
            for (int index = 0; index < executionVertex.getNumberOfInputs(); ++index) {
                for (ExecutionEdge edge : executionVertex.getInputEdges(index)) {
                    DefaultSchedulingResultPartition partition = resultPartitions.get((Object)edge.getSource().getPartitionId());
                    schedulingVertex.addConsumedPartition(partition);
                    partition.addConsumer(schedulingVertex);
                }
            }
        }
    }

    private static class ExecutionStateSupplier
    implements Supplier<ExecutionState> {
        private final ExecutionVertex executionVertex;

        ExecutionStateSupplier(ExecutionVertex vertex) {
            this.executionVertex = (ExecutionVertex)Preconditions.checkNotNull((Object)vertex);
        }

        @Override
        public ExecutionState get() {
            return this.executionVertex.getExecutionState();
        }
    }
}

