/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.util.Preconditions;

class DefaultSchedulingExecutionVertex
implements SchedulingExecutionVertex {
    private final ExecutionVertexID executionVertexId;
    private final List<SchedulingResultPartition> consumedPartitions;
    private final List<? extends SchedulingResultPartition> producedPartitions;
    private final Supplier<ExecutionState> stateSupplier;
    private final InputDependencyConstraint inputDependencyConstraint;

    DefaultSchedulingExecutionVertex(ExecutionVertexID executionVertexId, List<? extends SchedulingResultPartition> producedPartitions, Supplier<ExecutionState> stateSupplier, InputDependencyConstraint constraint) {
        this.executionVertexId = (ExecutionVertexID)Preconditions.checkNotNull((Object)executionVertexId);
        this.consumedPartitions = new ArrayList<SchedulingResultPartition>();
        this.stateSupplier = (Supplier)Preconditions.checkNotNull(stateSupplier);
        this.producedPartitions = (List)Preconditions.checkNotNull(producedPartitions);
        this.inputDependencyConstraint = (InputDependencyConstraint)Preconditions.checkNotNull((Object)constraint);
    }

    @Override
    public ExecutionVertexID getId() {
        return this.executionVertexId;
    }

    @Override
    public ExecutionState getState() {
        return this.stateSupplier.get();
    }

    @Override
    public Collection<SchedulingResultPartition> getConsumedResultPartitions() {
        return Collections.unmodifiableCollection(this.consumedPartitions);
    }

    @Override
    public Collection<SchedulingResultPartition> getProducedResultPartitions() {
        return Collections.unmodifiableCollection(this.producedPartitions);
    }

    @Override
    public InputDependencyConstraint getInputDependencyConstraint() {
        return this.inputDependencyConstraint;
    }

    <X extends SchedulingResultPartition> void addConsumedPartition(X partition) {
        this.consumedPartitions.add(partition);
    }
}

