/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.netty.CreditBasedPartitionRequestClientHandler;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.PartitionRequestClientHandler;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.netty.PartitionRequestServerHandler;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandlerAdapter;

public class NettyProtocol {
    private final NettyMessage.NettyMessageEncoder messageEncoder = new NettyMessage.NettyMessageEncoder();
    private final ResultPartitionProvider partitionProvider;
    private final TaskEventPublisher taskEventPublisher;
    private final boolean creditBasedEnabled;

    NettyProtocol(ResultPartitionProvider partitionProvider, TaskEventPublisher taskEventPublisher, boolean creditBasedEnabled) {
        this.partitionProvider = partitionProvider;
        this.taskEventPublisher = taskEventPublisher;
        this.creditBasedEnabled = creditBasedEnabled;
    }

    public ChannelHandler[] getServerChannelHandlers() {
        PartitionRequestQueue queueOfPartitionQueues = new PartitionRequestQueue();
        PartitionRequestServerHandler serverHandler = new PartitionRequestServerHandler(this.partitionProvider, this.taskEventPublisher, queueOfPartitionQueues, this.creditBasedEnabled);
        return new ChannelHandler[]{this.messageEncoder, new NettyMessage.NettyMessageDecoder(!this.creditBasedEnabled), serverHandler, queueOfPartitionQueues};
    }

    public ChannelHandler[] getClientChannelHandlers() {
        ChannelInboundHandlerAdapter networkClientHandler = this.creditBasedEnabled ? new CreditBasedPartitionRequestClientHandler() : new PartitionRequestClientHandler();
        return new ChannelHandler[]{this.messageEncoder, new NettyMessage.NettyMessageDecoder(!this.creditBasedEnabled), networkClientHandler};
    }
}

