/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.metrics;

import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.metrics.AbstractBuffersUsageGauge;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;

public class InputBufferPoolUsageGauge
extends AbstractBuffersUsageGauge {
    public InputBufferPoolUsageGauge(SingleInputGate[] inputGates) {
        super((SingleInputGate[])Preconditions.checkNotNull((Object)inputGates));
    }

    @Override
    public int calculateUsedBuffers(SingleInputGate inputGate) {
        BufferPool bufferPool = inputGate.getBufferPool();
        if (bufferPool != null) {
            return bufferPool.bestEffortGetNumOfUsedBuffers();
        }
        return 0;
    }

    @Override
    public int calculateTotalBuffers(SingleInputGate inputGate) {
        BufferPool bufferPool = inputGate.getBufferPool();
        if (bufferPool != null) {
            return bufferPool.getNumBuffers();
        }
        return 0;
    }
}

