/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailureHandlingResult;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartBackoffTimeStrategy;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.throwable.ThrowableClassifier;
import org.apache.flink.runtime.throwable.ThrowableType;
import org.apache.flink.util.Preconditions;

public class ExecutionFailureHandler {
    private final FailoverStrategy failoverStrategy;
    private final RestartBackoffTimeStrategy restartBackoffTimeStrategy;

    public ExecutionFailureHandler(FailoverStrategy failoverStrategy, RestartBackoffTimeStrategy restartBackoffTimeStrategy) {
        this.failoverStrategy = (FailoverStrategy)Preconditions.checkNotNull((Object)failoverStrategy);
        this.restartBackoffTimeStrategy = (RestartBackoffTimeStrategy)Preconditions.checkNotNull((Object)restartBackoffTimeStrategy);
    }

    public FailureHandlingResult getFailureHandlingResult(ExecutionVertexID failedTask, Throwable cause) {
        if (ExecutionFailureHandler.isUnrecoverableError(cause)) {
            return FailureHandlingResult.unrecoverable((Throwable)((Object)new JobException("The failure is not recoverable", cause)));
        }
        this.restartBackoffTimeStrategy.notifyFailure(cause);
        if (this.restartBackoffTimeStrategy.canRestart()) {
            return FailureHandlingResult.restartable(this.failoverStrategy.getTasksNeedingRestart(failedTask, cause), this.restartBackoffTimeStrategy.getBackoffTime());
        }
        return FailureHandlingResult.unrecoverable((Throwable)((Object)new JobException("Failed task restarting is suppressed by " + this.restartBackoffTimeStrategy, cause)));
    }

    @VisibleForTesting
    static boolean isUnrecoverableError(Throwable cause) {
        Optional<Throwable> unrecoverableError = ThrowableClassifier.findThrowableOfThrowableType(cause, ThrowableType.NonRecoverableError);
        return unrecoverableError.isPresent();
    }
}

