/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.failover.adapter.DefaultFailoverEdge;
import org.apache.flink.runtime.executiongraph.failover.adapter.DefaultFailoverVertex;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverTopology;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverVertex;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class DefaultFailoverTopology
implements FailoverTopology {
    private final boolean containsCoLocationConstraints;
    private final List<DefaultFailoverVertex> failoverVertices;

    public DefaultFailoverTopology(ExecutionGraph executionGraph) {
        Preconditions.checkNotNull((Object)executionGraph);
        this.containsCoLocationConstraints = executionGraph.getAllVertices().values().stream().map(ExecutionJobVertex::getCoLocationGroup).anyMatch(Objects::nonNull);
        this.failoverVertices = new ArrayList<DefaultFailoverVertex>();
        IdentityHashMap<ExecutionVertex, DefaultFailoverVertex> failoverVertexMap = new IdentityHashMap<ExecutionVertex, DefaultFailoverVertex>();
        for (ExecutionVertex vertex : executionGraph.getAllExecutionVertices()) {
            DefaultFailoverVertex failoverVertex = new DefaultFailoverVertex(new ExecutionVertexID(vertex.getJobvertexId(), vertex.getParallelSubtaskIndex()), vertex.getTaskNameWithSubtaskIndex());
            this.failoverVertices.add(failoverVertex);
            failoverVertexMap.put(vertex, failoverVertex);
        }
        this.connectVerticesWithEdges(failoverVertexMap);
    }

    private void connectVerticesWithEdges(Map<ExecutionVertex, DefaultFailoverVertex> failoverVertexMap) {
        for (ExecutionVertex vertex : failoverVertexMap.keySet()) {
            DefaultFailoverVertex failoverVertex = failoverVertexMap.get(vertex);
            vertex.getProducedPartitions().values().stream().map(IntermediateResultPartition::getConsumers).flatMap(Collection::stream).flatMap(Collection::stream).forEach(e -> {
                DefaultFailoverVertex consumerFailoverVertex = (DefaultFailoverVertex)failoverVertexMap.get(e.getTarget());
                DefaultFailoverEdge failoverEdge = new DefaultFailoverEdge(e.getSource().getPartitionId(), e.getSource().getResultType(), failoverVertex, consumerFailoverVertex);
                failoverVertex.addOutputEdge(failoverEdge);
                consumerFailoverVertex.addInputEdge(failoverEdge);
            });
        }
    }

    @Override
    public Iterable<? extends FailoverVertex> getFailoverVertices() {
        return this.failoverVertices;
    }

    @Override
    public boolean containsCoLocationConstraints() {
        return this.containsCoLocationConstraints;
    }
}

