/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.File;
import java.io.IOException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.dispatcher.ArchivedExecutionGraphStore;
import org.apache.flink.runtime.dispatcher.FileArchivedExecutionGraphStore;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.shaded.guava18.com.google.common.base.Ticker;

public abstract class SessionClusterEntrypoint
extends ClusterEntrypoint {
    public SessionClusterEntrypoint(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected ArchivedExecutionGraphStore createSerializableExecutionGraphStore(Configuration configuration, ScheduledExecutor scheduledExecutor) throws IOException {
        File tmpDir = new File(ConfigurationUtils.parseTempDirectories((Configuration)configuration)[0]);
        Time expirationTime = Time.seconds((long)configuration.getLong(JobManagerOptions.JOB_STORE_EXPIRATION_TIME));
        long maximumCacheSizeBytes = configuration.getLong(JobManagerOptions.JOB_STORE_CACHE_SIZE);
        return new FileArchivedExecutionGraphStore(tmpDir, expirationTime, maximumCacheSizeBytes, scheduledExecutor, Ticker.systemTicker());
    }
}

