/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.AbstractContainerOverlay;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkDistributionOverlay
extends AbstractContainerOverlay {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkDistributionOverlay.class);
    static final Path TARGET_ROOT = new Path("flink");
    final File flinkBinPath;
    final File flinkConfPath;
    final File flinkLibPath;
    final File flinkPluginsPath;

    public FlinkDistributionOverlay(File flinkBinPath, File flinkConfPath, File flinkLibPath, File flinkPluginsPath) {
        this.flinkBinPath = (File)Preconditions.checkNotNull((Object)flinkBinPath);
        this.flinkConfPath = (File)Preconditions.checkNotNull((Object)flinkConfPath);
        this.flinkLibPath = (File)Preconditions.checkNotNull((Object)flinkLibPath);
        this.flinkPluginsPath = (File)Preconditions.checkNotNull((Object)flinkPluginsPath);
    }

    @Override
    public void configure(ContainerSpecification container) throws IOException {
        container.getEnvironmentVariables().put("FLINK_HOME", TARGET_ROOT.toString());
        this.addPathRecursively(this.flinkBinPath, TARGET_ROOT, container);
        this.addPathRecursively(this.flinkConfPath, TARGET_ROOT, container);
        this.addPathRecursively(this.flinkLibPath, TARGET_ROOT, container);
        if (this.flinkPluginsPath.isDirectory()) {
            this.addPathRecursively(this.flinkPluginsPath, TARGET_ROOT, container);
        } else {
            LOG.warn("The plugins directory '" + this.flinkPluginsPath + "' doesn't exist.");
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        File flinkBinPath;
        File flinkConfPath;
        File flinkLibPath;
        File flinkPluginsPath;

        public Builder fromEnvironment(Configuration globalConfiguration) {
            this.flinkBinPath = Builder.getObligatoryFileFromEnvironment("FLINK_BIN_DIR");
            this.flinkConfPath = Builder.getObligatoryFileFromEnvironment("FLINK_CONF_DIR");
            this.flinkLibPath = Builder.getObligatoryFileFromEnvironment("FLINK_LIB_DIR");
            this.flinkPluginsPath = Builder.getObligatoryFileFromEnvironment("FLINK_PLUGINS_DIR");
            return this;
        }

        public FlinkDistributionOverlay build() {
            return new FlinkDistributionOverlay(this.flinkBinPath, this.flinkConfPath, this.flinkLibPath, this.flinkPluginsPath);
        }

        private static File getObligatoryFileFromEnvironment(String envVariableName) {
            String directory = System.getenv(envVariableName);
            Preconditions.checkState((directory != null ? 1 : 0) != 0, (String)"the %s environment variable must be set", (Object[])new Object[]{envVariableName});
            return new File(directory);
        }
    }
}

