/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.Channel;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelFuture;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.Channels;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ConnectTimeoutException;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.AbstractNioSelector;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.Boss;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import org.apache.flink.shaded.akka.org.jboss.netty.util.ThreadNameDeterminer;
import org.apache.flink.shaded.akka.org.jboss.netty.util.ThreadRenamingRunnable;
import org.apache.flink.shaded.akka.org.jboss.netty.util.Timeout;
import org.apache.flink.shaded.akka.org.jboss.netty.util.Timer;
import org.apache.flink.shaded.akka.org.jboss.netty.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioClientBoss
extends AbstractNioSelector
implements Boss {
    private final TimerTask wakeupTask = new TimerTask(){

        public void run(Timeout timeout) throws Exception {
            Selector selector = NioClientBoss.this.selector;
            if (selector != null && NioClientBoss.this.wakenUp.compareAndSet(false, true)) {
                selector.wakeup();
            }
        }
    };
    private final Timer timer;

    NioClientBoss(Executor bossExecutor, Timer timer, ThreadNameDeterminer determiner) {
        super(bossExecutor, determiner);
        this.timer = timer;
    }

    @Override
    protected ThreadRenamingRunnable newThreadRenamingRunnable(int id, ThreadNameDeterminer determiner) {
        return new ThreadRenamingRunnable(this, "New I/O boss #" + id, determiner);
    }

    @Override
    protected Runnable createRegisterTask(Channel channel, ChannelFuture future) {
        return new RegisterTask(this, (NioClientSocketChannel)channel);
    }

    @Override
    protected void process(Selector selector) {
        this.processSelectedKeys(selector.selectedKeys());
        long currentTimeNanos = System.nanoTime();
        NioClientBoss.processConnectTimeout(selector.keys(), currentTimeNanos);
    }

    private void processSelectedKeys(Set<SelectionKey> selectedKeys) {
        if (selectedKeys.isEmpty()) {
            return;
        }
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            if (!k.isValid()) {
                this.close(k);
                continue;
            }
            try {
                if (!k.isConnectable()) continue;
                NioClientBoss.connect(k);
            }
            catch (Throwable t) {
                NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
                ch.connectFuture.setFailure(t);
                Channels.fireExceptionCaught(ch, t);
                k.cancel();
                ch.worker.close(ch, Channels.succeededFuture(ch));
            }
        }
    }

    private static void processConnectTimeout(Set<SelectionKey> keys, long currentTimeNanos) {
        for (SelectionKey k : keys) {
            if (!k.isValid()) continue;
            NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
            if (ch.connectDeadlineNanos <= 0L || currentTimeNanos < ch.connectDeadlineNanos) continue;
            ConnectTimeoutException cause = new ConnectTimeoutException("connection timed out: " + ch.requestedRemoteAddress);
            ch.connectFuture.setFailure(cause);
            Channels.fireExceptionCaught(ch, (Throwable)cause);
            ch.worker.close(ch, Channels.succeededFuture(ch));
        }
    }

    private static void connect(SelectionKey k) throws IOException {
        NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
        try {
            if (((SocketChannel)ch.channel).finishConnect()) {
                k.cancel();
                if (ch.timoutTimer != null) {
                    ch.timoutTimer.cancel();
                }
                ch.worker.register(ch, ch.connectFuture);
            }
        }
        catch (ConnectException e) {
            ConnectException newE = new ConnectException(e.getMessage() + ": " + ch.requestedRemoteAddress);
            newE.setStackTrace(e.getStackTrace());
            throw newE;
        }
    }

    @Override
    protected void close(SelectionKey k) {
        NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
        ch.worker.close(ch, Channels.succeededFuture(ch));
    }

    private final class RegisterTask
    implements Runnable {
        private final NioClientBoss boss;
        private final NioClientSocketChannel channel;

        RegisterTask(NioClientBoss boss, NioClientSocketChannel channel) {
            this.boss = boss;
            this.channel = channel;
        }

        public void run() {
            int timeout = this.channel.getConfig().getConnectTimeoutMillis();
            if (timeout > 0 && !this.channel.isConnected()) {
                this.channel.timoutTimer = NioClientBoss.this.timer.newTimeout(NioClientBoss.this.wakeupTask, timeout, TimeUnit.MILLISECONDS);
            }
            try {
                ((SocketChannel)this.channel.channel).register(this.boss.selector, 8, this.channel);
            }
            catch (ClosedChannelException e) {
                this.channel.worker.close(this.channel, Channels.succeededFuture(this.channel));
            }
            int connectTimeout = this.channel.getConfig().getConnectTimeoutMillis();
            if (connectTimeout > 0) {
                this.channel.connectDeadlineNanos = System.nanoTime() + (long)connectTimeout * 1000000L;
            }
        }
    }
}

