/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderRetriever
implements LeaderRetrievalListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private AtomicReference<CompletableFuture<Tuple2<String, UUID>>> atomicLeaderFuture = new AtomicReference(new CompletableFuture());

    public Optional<Tuple2<String, UUID>> getLeaderNow() throws Exception {
        CompletableFuture<Tuple2<String, UUID>> leaderFuture = this.atomicLeaderFuture.get();
        if (leaderFuture != null) {
            if (leaderFuture.isDone()) {
                return Optional.of(leaderFuture.get());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public CompletableFuture<Tuple2<String, UUID>> getLeaderFuture() {
        return this.atomicLeaderFuture.get();
    }

    @Override
    public void notifyLeaderAddress(String leaderAddress, UUID leaderSessionID) {
        if (leaderAddress != null && !leaderAddress.equals("")) {
            try {
                CompletableFuture<Tuple2<String, UUID>> newLeaderFuture = CompletableFuture.completedFuture(Tuple2.of((Object)leaderAddress, (Object)leaderSessionID));
                CompletableFuture<Tuple2> oldLeaderFuture = this.atomicLeaderFuture.getAndSet(newLeaderFuture);
                if (!oldLeaderFuture.isDone()) {
                    oldLeaderFuture.complete(Tuple2.of((Object)leaderAddress, (Object)leaderSessionID));
                }
                this.notifyNewLeaderAddress(newLeaderFuture);
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void handleError(Exception exception) {
        this.log.error("Received error from LeaderRetrievalService.", (Throwable)exception);
        this.atomicLeaderFuture.get().completeExceptionally(exception);
    }

    protected void notifyNewLeaderAddress(CompletableFuture<Tuple2<String, UUID>> newLeaderAddressFuture) {
    }
}

