/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.LeaderRetriever;
import org.apache.flink.util.ExceptionUtils;

public abstract class LeaderGatewayRetriever<T extends RpcGateway>
extends LeaderRetriever
implements GatewayRetriever<T> {
    private final AtomicReference<CompletableFuture<T>> atomicGatewayFuture;
    private volatile CompletableFuture<T> initialGatewayFuture = new CompletableFuture();

    public LeaderGatewayRetriever() {
        this.atomicGatewayFuture = new AtomicReference<CompletableFuture<T>>(this.initialGatewayFuture);
    }

    @Override
    public CompletableFuture<T> getFuture() {
        CompletableFuture<T> currentGatewayFuture = this.atomicGatewayFuture.get();
        if (currentGatewayFuture.isCompletedExceptionally()) {
            try {
                currentGatewayFuture.get();
            }
            catch (InterruptedException | ExecutionException executionException) {
                String leaderAddress;
                try {
                    Tuple2<String, UUID> leaderAddressSessionId = this.getLeaderNow().orElse((Tuple2<String, UUID>)Tuple2.of((Object)"unknown address", (Object)HighAvailabilityServices.DEFAULT_LEADER_ID));
                    leaderAddress = (String)leaderAddressSessionId.f0;
                }
                catch (Exception e) {
                    this.log.warn("Could not obtain the current leader.", (Throwable)e);
                    leaderAddress = "unknown leader address";
                }
                if (this.log.isDebugEnabled() || this.log.isTraceEnabled()) {
                    this.log.warn("Error while retrieving the leader gateway. Retrying to connect to {}.", (Object)leaderAddress, (Object)ExceptionUtils.stripExecutionException((Throwable)executionException));
                }
                this.log.warn("Error while retrieving the leader gateway. Retrying to connect to {}.", (Object)leaderAddress);
            }
            CompletableFuture<T> newGatewayFuture = this.createGateway(this.getLeaderFuture());
            if (this.atomicGatewayFuture.compareAndSet(currentGatewayFuture, newGatewayFuture)) {
                return newGatewayFuture;
            }
            return this.atomicGatewayFuture.get();
        }
        return this.atomicGatewayFuture.get();
    }

    @Override
    public void notifyNewLeaderAddress(CompletableFuture<Tuple2<String, UUID>> newLeaderAddressFuture) {
        CompletableFuture<T> newGatewayFuture = this.createGateway(newLeaderAddressFuture);
        CompletableFuture oldGatewayFuture = this.atomicGatewayFuture.getAndSet(newGatewayFuture);
        if (oldGatewayFuture == this.initialGatewayFuture) {
            newGatewayFuture.whenComplete((t, throwable) -> {
                if (throwable != null) {
                    oldGatewayFuture.completeExceptionally((Throwable)throwable);
                } else {
                    oldGatewayFuture.complete(t);
                }
            });
            this.initialGatewayFuture = null;
        } else {
            oldGatewayFuture.cancel(false);
        }
    }

    protected abstract CompletableFuture<T> createGateway(CompletableFuture<Tuple2<String, UUID>> var1);
}

