/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class DuplicatingCheckpointOutputStream
extends CheckpointStreamFactory.CheckpointStateOutputStream {
    private static final int DEFAULT_BUFFER_SIZER = 8192;
    private final byte[] buffer;
    private int bufferIdx;
    private final CheckpointStreamFactory.CheckpointStateOutputStream primaryOutputStream;
    private final CheckpointStreamFactory.CheckpointStateOutputStream secondaryOutputStream;
    private Exception secondaryStreamException;

    public DuplicatingCheckpointOutputStream(CheckpointStreamFactory.CheckpointStateOutputStream primaryOutputStream, CheckpointStreamFactory.CheckpointStateOutputStream secondaryOutputStream) throws IOException {
        this(primaryOutputStream, secondaryOutputStream, 8192);
    }

    public DuplicatingCheckpointOutputStream(CheckpointStreamFactory.CheckpointStateOutputStream primaryOutputStream, CheckpointStreamFactory.CheckpointStateOutputStream secondaryOutputStream, int bufferSize) throws IOException {
        this.primaryOutputStream = (CheckpointStreamFactory.CheckpointStateOutputStream)((Object)Preconditions.checkNotNull((Object)((Object)primaryOutputStream)));
        this.secondaryOutputStream = (CheckpointStreamFactory.CheckpointStateOutputStream)((Object)Preconditions.checkNotNull((Object)((Object)secondaryOutputStream)));
        this.buffer = new byte[bufferSize];
        this.bufferIdx = 0;
        this.secondaryStreamException = null;
        this.checkForAlignedStreamPositions();
    }

    public void write(int b) throws IOException {
        if (this.buffer.length <= this.bufferIdx) {
            this.flushInternalBuffer();
        }
        this.buffer[this.bufferIdx] = (byte)b;
        ++this.bufferIdx;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer.length <= len) {
            this.flushInternalBuffer();
            this.writeThroughInternal(b, off, len);
        } else {
            if (this.buffer.length < len + this.bufferIdx) {
                this.flushInternalBuffer();
            }
            System.arraycopy(b, off, this.buffer, this.bufferIdx, len);
            this.bufferIdx += len;
        }
    }

    public long getPos() throws IOException {
        long referencePos = this.primaryOutputStream.getPos();
        return referencePos + (long)this.bufferIdx;
    }

    public void flush() throws IOException {
        this.flushInternalBuffer();
        this.primaryOutputStream.flush();
        if (this.secondaryStreamException == null) {
            try {
                this.secondaryOutputStream.flush();
            }
            catch (Exception flushEx) {
                this.handleSecondaryStreamOnException(flushEx);
            }
        }
    }

    public void sync() throws IOException {
        this.flushInternalBuffer();
        this.primaryOutputStream.sync();
        if (this.secondaryStreamException == null) {
            try {
                this.secondaryOutputStream.sync();
            }
            catch (Exception syncEx) {
                this.handleSecondaryStreamOnException(syncEx);
            }
        }
    }

    @Override
    public void close() throws IOException {
        Exception exCollector = null;
        try {
            this.flushInternalBuffer();
        }
        catch (Exception flushEx) {
            exCollector = flushEx;
        }
        try {
            this.primaryOutputStream.close();
        }
        catch (Exception closeEx) {
            exCollector = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)closeEx, (Throwable)exCollector);
        }
        if (this.secondaryStreamException == null) {
            try {
                this.secondaryOutputStream.close();
            }
            catch (Exception closeEx) {
                this.handleSecondaryStreamOnException(closeEx);
            }
        }
        if (exCollector != null) {
            throw new IOException("Exception while closing duplicating stream.", exCollector);
        }
    }

    private void checkForAlignedStreamPositions() throws IOException {
        if (this.secondaryStreamException != null) {
            return;
        }
        long primaryPos = this.primaryOutputStream.getPos();
        try {
            long secondaryPos = this.secondaryOutputStream.getPos();
            if (primaryPos != secondaryPos) {
                this.handleSecondaryStreamOnException(new IOException("Stream positions are out of sync between primary stream and secondary stream. Reported positions are " + primaryPos + " (primary) and " + secondaryPos + " (secondary)."));
            }
        }
        catch (Exception posEx) {
            this.handleSecondaryStreamOnException(posEx);
        }
    }

    private void flushInternalBuffer() throws IOException {
        if (this.bufferIdx > 0) {
            this.writeThroughInternal(this.buffer, 0, this.bufferIdx);
            this.bufferIdx = 0;
        }
    }

    private void writeThroughInternal(byte[] b, int off, int len) throws IOException {
        this.primaryOutputStream.write(b, off, len);
        if (this.secondaryStreamException == null) {
            try {
                this.secondaryOutputStream.write(b, off, len);
            }
            catch (Exception writeEx) {
                this.handleSecondaryStreamOnException(writeEx);
            }
        }
    }

    private void handleSecondaryStreamOnException(Exception ex) {
        Preconditions.checkState((this.secondaryStreamException == null ? 1 : 0) != 0, (Object)"Secondary stream already failed from previous exception!");
        try {
            this.secondaryOutputStream.close();
        }
        catch (Exception closeEx) {
            ex = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)closeEx, (Throwable)ex);
        }
        this.secondaryStreamException = (Exception)Preconditions.checkNotNull((Object)ex);
    }

    @Override
    @Nullable
    public StreamStateHandle closeAndGetHandle() throws IOException {
        return this.closeAndGetPrimaryHandle();
    }

    public StreamStateHandle closeAndGetPrimaryHandle() throws IOException {
        this.flushInternalBuffer();
        return this.primaryOutputStream.closeAndGetHandle();
    }

    public StreamStateHandle closeAndGetSecondaryHandle() throws IOException {
        if (this.secondaryStreamException == null) {
            this.flushInternalBuffer();
            return this.secondaryOutputStream.closeAndGetHandle();
        }
        throw new IOException("Secondary stream previously failed exceptionally", this.secondaryStreamException);
    }

    public Exception getSecondaryStreamException() {
        return this.secondaryStreamException;
    }

    @VisibleForTesting
    CheckpointStreamFactory.CheckpointStateOutputStream getPrimaryOutputStream() {
        return this.primaryOutputStream;
    }

    @VisibleForTesting
    CheckpointStreamFactory.CheckpointStateOutputStream getSecondaryOutputStream() {
        return this.secondaryOutputStream;
    }
}

