/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.messages;

import org.apache.flink.runtime.rpc.messages.RpcInvocation;
import org.apache.flink.util.Preconditions;

public final class LocalRpcInvocation
implements RpcInvocation {
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final Object[] args;
    private transient String toString;

    public LocalRpcInvocation(String methodName, Class<?>[] parameterTypes, Object[] args) {
        this.methodName = (String)Preconditions.checkNotNull((Object)methodName);
        this.parameterTypes = (Class[])Preconditions.checkNotNull(parameterTypes);
        this.args = args;
        this.toString = null;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder paramTypeStringBuilder = new StringBuilder(this.parameterTypes.length * 5);
            if (this.parameterTypes.length > 0) {
                paramTypeStringBuilder.append(this.parameterTypes[0].getSimpleName());
                for (int i = 1; i < this.parameterTypes.length; ++i) {
                    paramTypeStringBuilder.append(", ").append(this.parameterTypes[i].getSimpleName());
                }
            }
            this.toString = "LocalRpcInvocation(" + this.methodName + '(' + paramTypeStringBuilder + "))";
        }
        return this.toString;
    }
}

